/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http.error;

import io.rxmicro.common.RxMicroException;

public abstract class HttpErrorException
extends RxMicroException {
    private static final int MIN_SUPPORTED_INFORMATIONAL_CODE = 100;
    private static final int MAX_SUPPORTED_INFORMATIONAL_CODE = 199;
    private static final int MIN_SUPPORTED_SUCCESS_CODE = 200;
    private static final int MAX_SUPPORTED_SUCCESS_CODE = 299;
    private static final int MIN_SUPPORTED_REDIRECT_CODE = 300;
    private static final int MAX_SUPPORTED_REDIRECT_CODE = 399;
    private static final int MIN_SUPPORTED_CLIENT_ERROR_CODE = 400;
    private static final int MAX_SUPPORTED_CLIENT_ERROR_CODE = 499;
    private static final int MIN_SUPPORTED_SERVER_ERROR_CODE = 500;
    private static final int MAX_SUPPORTED_SERVER_ERROR_CODE = 599;
    private final int statusCode;

    protected HttpErrorException(int statusCode, String message) {
        super(true, false, message);
        this.statusCode = statusCode;
    }

    protected HttpErrorException(int statusCode, String message, Object ... args) {
        super(true, false, message, args);
        this.statusCode = statusCode;
    }

    protected HttpErrorException(int statusCode) {
        super(true, false);
        this.statusCode = statusCode;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final boolean isInformationalCode() {
        return this.statusCode >= 100 && this.statusCode < 199;
    }

    public final boolean isSuccessCode() {
        return this.statusCode >= 200 && this.statusCode < 299;
    }

    public final boolean isRedirectCode() {
        return this.statusCode >= 300 && this.statusCode < 399;
    }

    public final boolean isClientErrorCode() {
        return this.statusCode >= 400 && this.statusCode < 499;
    }

    public final boolean isServerErrorCode() {
        return this.statusCode >= 500 && this.statusCode < 599;
    }
}

