/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public final class HttpValues {
    public static final String STRING_ARRAY_DELIMITER = "|";

    public static String arrayToString(Object array) {
        StringBuilder stringBuilder = new StringBuilder(50);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                stringBuilder.append(STRING_ARRAY_DELIMITER);
            }
            stringBuilder.append(HttpValues.simpleObjectToString(Array.get(array, i)));
        }
        return stringBuilder.toString();
    }

    public static String listToString(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder(50);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(STRING_ARRAY_DELIMITER);
            }
            stringBuilder.append(HttpValues.simpleObjectToString(list.get(i)));
        }
        return stringBuilder.toString();
    }

    public static String collectionToString(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder(50);
        for (Object o : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(STRING_ARRAY_DELIMITER);
            }
            stringBuilder.append(HttpValues.simpleObjectToString(o));
        }
        return stringBuilder.toString();
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Collection) {
            return HttpValues.collectionToString((Collection)value);
        }
        if (value.getClass().isArray()) {
            return HttpValues.arrayToString(value);
        }
        return value.toString();
    }

    private static String simpleObjectToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    private HttpValues() {
    }
}

