/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http;

import java.util.Map;

public final class HttpStatuses {
    public static final int CONTINUE_100 = 100;
    public static final int SWITCHING_PROTOCOLS_101 = 101;
    public static final int PROCESSING_102 = 102;
    public static final int EARLY_HINTS_103 = 103;
    public static final int OK_200 = 200;
    public static final int CREATED_201 = 201;
    public static final int ACCEPTED_202 = 202;
    public static final int NON_AUTHORITATIVE_INFORMATION_203 = 203;
    public static final int NO_CONTENT_204 = 204;
    public static final int RESET_CONTENT_205 = 205;
    public static final int PARTIAL_CONTENT_206 = 206;
    public static final int MULTI_STATUS_207 = 207;
    public static final int ALREADY_REPORTED_208 = 208;
    public static final int IM_USED_226 = 226;
    public static final int MULTIPLE_CHOICES_300 = 300;
    public static final int MOVED_PERMANENTLY_301 = 301;
    public static final int MOVED_TEMPORARY_302 = 302;
    public static final int FOUND_302 = 302;
    public static final int SEE_OTHER_303 = 303;
    public static final int NOT_MODIFIED_304 = 304;
    public static final int USE_PROXY_305 = 305;
    public static final int SWITCH_PROXY_306 = 306;
    public static final int TEMPORARY_REDIRECT_307 = 307;
    public static final int PERMANENT_REDIRECT_308 = 308;
    public static final int BAD_REQUEST_400 = 400;
    public static final int UNAUTHORIZED_401 = 401;
    public static final int PAYMENT_REQUIRED_402 = 402;
    public static final int FORBIDDEN_403 = 403;
    public static final int NOT_FOUND_404 = 404;
    public static final int METHOD_NOT_ALLOWED_405 = 405;
    public static final int NOT_ACCEPTABLE_406 = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED_407 = 407;
    public static final int REQUEST_TIMEOUT_408 = 408;
    public static final int CONFLICT_409 = 409;
    public static final int GONE_410 = 410;
    public static final int LENGTH_REQUIRED_411 = 411;
    public static final int PRECONDITION_FAILED_412 = 412;
    public static final int PAYLOAD_TOO_LARGE_413 = 413;
    public static final int URI_TOO_LONG_414 = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE_415 = 415;
    public static final int RANGE_NOT_SATISFIABLE_416 = 416;
    public static final int EXPECTATION_FAILED_417 = 417;
    public static final int I_M_A_TEAPOT_418 = 418;
    public static final int AUTHENTICATION_TIMEOUT_419 = 419;
    public static final int ENHANCE_YOUR_CALM_420 = 420;
    public static final int MISDIRECTED_REQUEST_421 = 421;
    public static final int UNPROCESSABLE_ENTITY_422 = 422;
    public static final int LOCKED_423 = 423;
    public static final int FAILED_DEPENDENCY_424 = 424;
    public static final int TOO_EARLY_425 = 425;
    public static final int UPGRADE_REQUIRED_426 = 426;
    public static final int PRECONDITION_REQUIRED_428 = 428;
    public static final int TOO_MANY_REQUESTS_429 = 429;
    public static final int REQUEST_HEADER_FIELDS_TOO_LARGE_431 = 431;
    public static final int NO_RESPONSE_444 = 444;
    public static final int RETRY_WITH_449 = 449;
    public static final int BLOCKED_BY_WINDOWS_PARENTAL_CONTROLS_450 = 450;
    public static final int UNAVAILABLE_FOR_LEGAL_REASONS_451 = 451;
    public static final int CLIENT_CLOSED_REQUEST_499 = 499;
    public static final int INTERNAL_SERVER_ERROR_500 = 500;
    public static final int NOT_IMPLEMENTED_501 = 501;
    public static final int BAD_GATEWAY_502 = 502;
    public static final int SERVICE_UNAVAILABLE_503 = 503;
    public static final int GATEWAY_TIMEOUT_504 = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED_505 = 505;
    public static final int VARIANT_ALSO_NEGOTIATES_506 = 506;
    public static final int INSUFFICIENT_STORAGE_507 = 507;
    public static final int LOOP_DETECTED_508 = 508;
    public static final int BANDWIDTH_LIMIT_EXCEEDED_509 = 509;
    public static final int NOT_EXTENDED_510 = 510;
    public static final int NETWORK_AUTHENTICATION_REQUIRED_511 = 511;
    public static final int UNKNOWN_ERROR_520 = 520;
    public static final int WEB_SERVER_IS_DOWN_521 = 521;
    public static final int CONNECTION_TIMED_OUT_522 = 522;
    public static final int ORIGIN_IS_UNREACHABLE_523 = 523;
    public static final int A_TIMEOUT_OCCURRED_524 = 524;
    public static final int SSL_HANDSHAKE_FAILED_525 = 525;
    public static final int INVALID_SSL_CERTIFICATE_526 = 526;
    public static final int NETWORK_READ_TIMEOUT_ERROR_598 = 598;
    public static final int NETWORK_CONNECT_TIMEOUT_ERROR_599 = 599;
    private static final Map<Integer, String> STATUES = Map.ofEntries(Map.entry(100, "Continue"), Map.entry(101, "Switching Protocols"), Map.entry(102, "Processing"), Map.entry(103, "Early Hints"), Map.entry(200, "OK"), Map.entry(201, "Created"), Map.entry(202, "Accepted"), Map.entry(203, "Non-Authoritative Information"), Map.entry(204, "No Content"), Map.entry(205, "Reset Content"), Map.entry(206, "Partial Content"), Map.entry(207, "Multi-Status"), Map.entry(208, "Already Reported"), Map.entry(226, "IM Used"), Map.entry(300, "Multiple Choices"), Map.entry(301, "Moved Permanently"), Map.entry(302, "Found"), Map.entry(303, "See Other"), Map.entry(304, "Not Modified"), Map.entry(305, "Use Proxy"), Map.entry(306, "Switch Proxy"), Map.entry(307, "Temporary Redirect"), Map.entry(308, "Permanent Redirect"), Map.entry(400, "Bad Request"), Map.entry(401, "Unauthorized"), Map.entry(402, "Payment Required"), Map.entry(403, "Forbidden"), Map.entry(404, "Not Found"), Map.entry(405, "Method Not Allowed"), Map.entry(406, "Not Acceptable"), Map.entry(407, "Proxy Authentication Required"), Map.entry(408, "Request Timeout"), Map.entry(409, "Conflict"), Map.entry(410, "Gone"), Map.entry(411, "Length Required"), Map.entry(412, "Precondition Failed"), Map.entry(413, "Payload Too Large"), Map.entry(414, "URI Too Long"), Map.entry(415, "Unsupported Media Type"), Map.entry(416, "Range Not Satisfiable"), Map.entry(417, "Expectation Failed"), Map.entry(418, "I'm a teapot"), Map.entry(419, "Authentication Timeout"), Map.entry(420, "Enhance Your Calm"), Map.entry(421, "Misdirected Request"), Map.entry(422, "Unprocessable Entity"), Map.entry(423, "Locked"), Map.entry(424, "Failed Dependency"), Map.entry(425, "Too Early"), Map.entry(426, "Upgrade Required"), Map.entry(428, "Precondition Required"), Map.entry(429, "Too Many Requests"), Map.entry(431, "Request Header Fields Too Large"), Map.entry(444, "No Response"), Map.entry(449, "Retry With"), Map.entry(450, "Blocked by Windows Parental Controls"), Map.entry(451, "Unavailable For Legal Reasons"), Map.entry(499, "Client Closed Request"), Map.entry(500, "Internal Server Error"), Map.entry(501, "Not Implemented"), Map.entry(502, "Bad Gateway"), Map.entry(503, "Service Unavailable"), Map.entry(504, "Gateway Timeout"), Map.entry(505, "HTTP Version Not Supported"), Map.entry(506, "Variant Also Negotiates"), Map.entry(507, "Insufficient Storage"), Map.entry(508, "Loop Detected"), Map.entry(509, "Bandwidth Limit Exceeded"), Map.entry(510, "Not Extended"), Map.entry(511, "Network Authentication Required"), Map.entry(520, "Unknown Error"), Map.entry(521, "Web Server Is Down"), Map.entry(522, "Connection Timed Out"), Map.entry(523, "Origin Is Unreachable"), Map.entry(524, "A Timeout Occurred"), Map.entry(525, "SSL Handshake Failed"), Map.entry(526, "Invalid SSL Certificate"), Map.entry(598, "Network read timeout error"), Map.entry(599, "Network connect timeout error"));
    private static final int MIN_SUPPORTED_HTTP_STATUS = 100;
    private static final int MAX_SUPPORTED_HTTP_STATUS = 599;

    public static String getErrorMessage(int status) {
        if (status < 100 || status > 599) {
            throw new IllegalArgumentException("Invalid status code: " + status);
        }
        return STATUES.getOrDefault(status, "Unofficial code: " + status);
    }

    private HttpStatuses() {
    }
}

