/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Config;
import io.rxmicro.config.Networks;
import io.rxmicro.http.ProtocolSchema;
import io.rxmicro.http.internal.HttpConfigExtractor;

public class HttpConfig
extends Config {
    private ProtocolSchema schema;
    private String host;
    private int port;

    protected HttpConfig() {
    }

    public ProtocolSchema getSchema() {
        return this.schema;
    }

    public HttpConfig setSchema(ProtocolSchema schema) {
        this.schema = (ProtocolSchema)((Object)Requires.require((Object)((Object)schema)));
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public HttpConfig setHost(String host) {
        this.host = (String)Requires.require((Object)host);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public HttpConfig setPort(int port) {
        this.port = Networks.validatePort((int)port);
        return this;
    }

    public String getConnectionString() {
        if (this.port == this.schema.getPort()) {
            return Formats.format((String)"?://?", (Object[])new Object[]{this.schema.getSchema(), this.host});
        }
        return Formats.format((String)"?://?:?", (Object[])new Object[]{this.schema.getSchema(), this.host, this.port});
    }

    public HttpConfig setConnectionString(String connectionString) {
        new HttpConfigExtractor().extract(connectionString, this);
        return this;
    }

    public String toString() {
        return "HttpConfig {connectionString='" + this.getConnectionString() + "'}";
    }
}

