/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.model;

import io.rxmicro.data.sql.model.reactor.Transaction;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum TransactionType {
    REACTOR(Transaction.class),
    RX_JAVA_3(io.rxmicro.data.sql.model.rxjava3.Transaction.class),
    COMPLETABLE_FUTURE(io.rxmicro.data.sql.model.completablefuture.Transaction.class);

    public static final Set<String> SUPPORTED_TRANSACTION_TYPES;
    private final Class<?> transactionClass;

    public static TransactionType byClassName(String fullClassName) {
        for (TransactionType transactionType : TransactionType.values()) {
            if (!transactionType.transactionClass.getName().equals(fullClassName)) continue;
            return transactionType;
        }
        throw new IllegalArgumentException("Unsupported transaction type: " + fullClassName);
    }

    private TransactionType(Class<?> transactionClass) {
        this.transactionClass = transactionClass;
    }

    static {
        SUPPORTED_TRANSACTION_TYPES = Arrays.stream(TransactionType.values()).map(e -> e.transactionClass.getName()).collect(Collectors.toUnmodifiableSet());
    }
}

