/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.detail;

import io.rxmicro.common.util.Formats;
import io.rxmicro.data.detail.AbstractDataRepository;
import io.rxmicro.data.sql.model.InvalidDatabaseStateException;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import java.util.Arrays;
import reactor.core.publisher.Mono;

public abstract class AbstractSQLRepository
extends AbstractDataRepository {
    protected final Logger logger;

    protected AbstractSQLRepository(Class<?> repositoryInterface) {
        this.logger = LoggerFactory.getLogger(repositoryInterface);
    }

    protected final int validateRowsUpdated(int expected, int actual, String sql, Object ... params) {
        if (expected != actual) {
            throw new InvalidDatabaseStateException("Last DML operation failed: Expected ? updated row count, but actual is ? for the SQL: '?'?!", expected, actual, sql, this.getWithParamsPhrase(params));
        }
        return actual;
    }

    protected final <T> Mono<T> throwExceptionIfEmptyResult(String sql, Object ... params) {
        return Mono.error(() -> new InvalidDatabaseStateException("Last DML operation failed: Expected 1 updated row count, but actual is 0 for the SQL: '?'?!", sql, this.getWithParamsPhrase(params)));
    }

    protected final <T> T throwExceptionIfNotEmptyResult(String sql, Object ... params) {
        throw new InvalidDatabaseStateException("Last DML operation failed: Expected 0 updated row count, but actual is 1 for the SQL: '?'?!", sql, this.getWithParamsPhrase(params));
    }

    private String getWithParamsPhrase(Object ... params) {
        if (params.length == 0) {
            return "";
        }
        return Formats.format((String)" with params ?", (Object[])new Object[]{this.paramsToString(params)});
    }

    private String paramsToString(Object ... params) {
        if (params[0].getClass().isArray()) {
            return Arrays.toString((Object[])params[0]);
        }
        return Arrays.toString(params);
    }
}

