/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql;

import io.rxmicro.common.util.Requires;
import io.rxmicro.data.sql.SQLDatabaseConfig;
import java.time.Duration;
import java.util.Map;

public class SQLPooledDatabaseConfig
extends SQLDatabaseConfig {
    public static final int DEFAULT_ACQUIRE_RETRY = 2;
    public static final int DEFAULT_INIT_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 5;
    public static final Duration DEFAULT_MAX_IDLE_DURATION = Duration.ofMinutes(30L);
    public static final String DEFAULT_VALIDATION_QUERY = "SELECT 2+2";
    private int acquireRetry = 2;
    private int initialSize = 3;
    private int maxSize = 5;
    private String validationQuery = "SELECT 2+2";
    private Duration maxIdleTime = DEFAULT_MAX_IDLE_DURATION;
    private Duration maxCreateConnectionTime = Duration.ZERO;
    private Duration maxAcquireTime = Duration.ZERO;
    private Duration maxLifeTime = Duration.ZERO;

    public int getAcquireRetry() {
        return this.acquireRetry;
    }

    public SQLPooledDatabaseConfig setAcquireRetry(int acquireRetry) {
        this.acquireRetry = acquireRetry;
        return this;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public SQLPooledDatabaseConfig setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        if (initialSize > this.maxSize) {
            this.maxSize = initialSize;
        }
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public SQLPooledDatabaseConfig setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if (this.initialSize > maxSize) {
            this.initialSize = maxSize;
        }
        return this;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public SQLPooledDatabaseConfig setValidationQuery(String validationQuery) {
        this.validationQuery = (String)Requires.require((Object)validationQuery);
        return this;
    }

    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public SQLPooledDatabaseConfig setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = (Duration)Requires.require((Object)maxIdleTime);
        return this;
    }

    public Duration getMaxCreateConnectionTime() {
        return this.maxCreateConnectionTime;
    }

    public SQLPooledDatabaseConfig setMaxCreateConnectionTime(Duration maxCreateConnectionTime) {
        this.maxCreateConnectionTime = (Duration)Requires.require((Object)maxCreateConnectionTime);
        return this;
    }

    public Duration getMaxAcquireTime() {
        return this.maxAcquireTime;
    }

    public SQLPooledDatabaseConfig setMaxAcquireTime(Duration maxAcquireTime) {
        this.maxAcquireTime = (Duration)Requires.require((Object)maxAcquireTime);
        return this;
    }

    public Duration getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public SQLPooledDatabaseConfig setMaxLifeTime(Duration maxLifeTime) {
        this.maxLifeTime = (Duration)Requires.require((Object)maxLifeTime);
        return this;
    }

    @Override
    public SQLPooledDatabaseConfig setHost(String host) {
        return (SQLPooledDatabaseConfig)super.setHost(host);
    }

    @Override
    public SQLPooledDatabaseConfig setPort(int port) {
        return (SQLPooledDatabaseConfig)super.setPort(port);
    }

    @Override
    public SQLPooledDatabaseConfig setUser(String user) {
        return (SQLPooledDatabaseConfig)super.setUser(user);
    }

    @Override
    public SQLPooledDatabaseConfig setPassword(CharSequence password) {
        return (SQLPooledDatabaseConfig)super.setPassword(password);
    }

    @Override
    public SQLPooledDatabaseConfig setDatabase(String database) {
        return (SQLPooledDatabaseConfig)super.setDatabase(database);
    }

    @Override
    public SQLPooledDatabaseConfig setOptions(Map<String, String> options) {
        return (SQLPooledDatabaseConfig)super.setOptions(options);
    }

    @Override
    public SQLPooledDatabaseConfig setConnectTimeout(Duration connectTimeout) {
        return (SQLPooledDatabaseConfig)super.setConnectTimeout(connectTimeout);
    }
}

