/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Config;
import io.rxmicro.config.ConfigException;
import io.rxmicro.config.Networks;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class SQLDatabaseConfig
extends Config {
    public static final String DEFAULT_HOST = "localhost";
    private Map<String, String> options;
    private String host = "localhost";
    private int port = -1;
    private String user;
    private CharSequence password;
    private String database;
    private Duration connectTimeout;

    public String getHost() {
        return this.host;
    }

    public SQLDatabaseConfig setHost(String host) {
        this.host = (String)Requires.require((Object)host);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public SQLDatabaseConfig setPort(int port) {
        this.port = Networks.validatePort((int)port);
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public SQLDatabaseConfig setUser(String user) {
        this.user = (String)Requires.require((Object)user);
        return this;
    }

    public CharSequence getPassword() {
        return this.password;
    }

    public SQLDatabaseConfig setPassword(CharSequence password) {
        this.password = (CharSequence)Requires.require((Object)password);
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public SQLDatabaseConfig setDatabase(String database) {
        this.database = (String)Requires.require((Object)database);
        return this;
    }

    public SQLDatabaseConfig setOptions(Map<String, String> options) {
        this.options = (Map)Requires.require(options);
        return this;
    }

    public Optional<Map<String, String>> getOptions() {
        return Optional.ofNullable(this.options).filter(m -> !m.isEmpty());
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public SQLDatabaseConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = (Duration)Requires.require((Object)connectTimeout);
        return this;
    }

    public String getConnectionString() {
        return Formats.format((String)"sql://?:?/?", (Object[])new Object[]{this.host, this.port, this.database});
    }

    protected void validate(String namespace) {
        ArrayList<String> properties = new ArrayList<String>();
        if (this.port == -1) {
            properties.add(Formats.format((String)"?.port", (Object[])new Object[]{namespace}));
        }
        if (this.user == null) {
            properties.add(Formats.format((String)"?.user", (Object[])new Object[]{namespace}));
        }
        if (this.password == null) {
            properties.add(Formats.format((String)"?.password", (Object[])new Object[]{namespace}));
        }
        if (this.database == null) {
            properties.add(Formats.format((String)"?.database", (Object[])new Object[]{namespace}));
        }
        if (!properties.isEmpty()) {
            throw new ConfigException("Can't create instance of '?' class for '?' namespace, because required property(ies) is(are) missing: ?!", new Object[]{((Object)((Object)this)).getClass().getName(), namespace, properties});
        }
    }
}

