/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.internal;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.data.sql.r2dbc.detail.RepositoryConnection;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.RequestIdSupplier;
import java.util.Arrays;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Statements {
    private final Logger logger;

    public Statements(Logger logger) {
        this.logger = logger;
    }

    public Mono<? extends Result> executeStatement(RepositoryConnection connection, String sql) {
        this.logStatement(connection, sql, new Object[0]);
        Statement statement = connection.createStatement(sql);
        return this.execute(connection, statement, sql, new Object[0]);
    }

    public Mono<? extends Result> executeStatement(RepositoryConnection connection, String sql, Object ... params) {
        this.logStatement(connection, sql, params);
        Statement statement = connection.createStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            Object param = Requires.require((Object)params[i], (String)"Bind parameter must be not null: sql='?', index=[?]! For null param use 'WHERE column IS NULL' instead of 'WHERE column=?', where '?' is placeholder for 'null' value!", (Object[])new Object[]{sql, i + 1});
            statement.bind(i, param);
        }
        return this.execute(connection, statement, sql, params);
    }

    public Mono<? extends Result> executeStatement(RepositoryConnection connection, String sql, Object[] params, Class<?>[] types) {
        this.logStatement(connection, sql, params);
        Statement statement = connection.createStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) {
                statement.bindNull(i, types[i]);
                continue;
            }
            statement.bind(i, param);
        }
        return this.execute(connection, statement, sql, params);
    }

    private void logStatement(RepositoryConnection connection, String sql, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((RequestIdSupplier)connection, "Execute SQL '?'? using connection: class='?', id='?'...", (Object)sql, (Object)this.getWithParamsString(params), (Object)connection.getConnectionClassName(), (Object)connection.getConnectionId());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((RequestIdSupplier)connection, "Execute SQL '?' using connection with id='?'...", (Object)sql, (Object)connection.getConnectionId());
        }
    }

    private Mono<? extends Result> execute(RepositoryConnection connection, Statement statement, String sql, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            return Mono.from((Publisher)statement.execute()).doOnSuccess(r -> this.logger.trace((RequestIdSupplier)connection, "SQL '?'? executed successful", (Object)sql, (Object)this.getWithParamsString(params)));
        }
        return Mono.from((Publisher)statement.execute());
    }

    private String getWithParamsString(Object[] params) {
        return params.length > 0 ? Formats.format((String)" with params: ?", (Object[])new Object[]{Arrays.toString(params)}) : "";
    }
}

