/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.internal;

import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.ValidationDepth;
import io.rxmicro.data.sql.r2dbc.detail.RepositoryConnection;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.logger.RequestIdSupplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class RepositoryConnectionImpl
implements RepositoryConnection {
    private final Logger logger;
    private final Connection connection;
    private final String requestId;

    public RepositoryConnectionImpl(Class<?> repositoryInterface, Connection connection) {
        this.logger = LoggerFactory.getLogger(repositoryInterface);
        this.connection = connection;
        this.requestId = "null";
    }

    public RepositoryConnectionImpl(Class<?> repositoryInterface, Connection connection, String requestId) {
        this.logger = LoggerFactory.getLogger(repositoryInterface);
        this.connection = connection;
        this.requestId = requestId;
    }

    @Override
    public Mono<Void> beginTransaction() {
        Mono mono = Mono.from((Publisher)this.connection.beginTransaction());
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Transaction started using connection: class='?', id='?'.", (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    @Override
    public Mono<Void> close() {
        Mono mono = Mono.from((Publisher)this.connection.close());
        if (this.logger.isTraceEnabled()) {
            return mono.doFinally(s -> this.logger.trace((RequestIdSupplier)this, "Connection closed: class='?', id='?', signal='?'", (Object)this.getConnectionClassName(), (Object)this.getConnectionId(), s));
        }
        return mono;
    }

    @Override
    public Mono<Void> commitTransaction() {
        Mono mono = Mono.from((Publisher)this.connection.commitTransaction());
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Transaction committed using connection: class='?', id='?'.", (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    public Batch createBatch() {
        return this.connection.createBatch();
    }

    @Override
    public Mono<Void> createSavepoint(String name) {
        Mono mono = Mono.from((Publisher)this.connection.createSavepoint(name));
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Save point created with name='?' using connection: class='?', id='?'.", (Object)name, (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    public Statement createStatement(String sql) {
        return this.connection.createStatement(sql);
    }

    public boolean isAutoCommit() {
        return this.connection.isAutoCommit();
    }

    public ConnectionMetadata getMetadata() {
        return this.connection.getMetadata();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return this.connection.getTransactionIsolationLevel();
    }

    @Override
    public Mono<Void> releaseSavepoint(String name) {
        Mono mono = Mono.from((Publisher)this.connection.releaseSavepoint(name));
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Save point released with name='?' using connection: class='?', id='?'.", (Object)name, (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    @Override
    public Mono<Void> rollbackTransaction() {
        Mono mono = Mono.from((Publisher)this.connection.rollbackTransaction());
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Transaction rolled back using connection: class='?', id='?'.", (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    @Override
    public Mono<Void> rollbackTransactionToSavepoint(String name) {
        Mono mono = Mono.from((Publisher)this.connection.rollbackTransactionToSavepoint(name));
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Transaction rolled back to save point with name='?' using connection: class='?', id='?'.", (Object)name, (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    @Override
    public Mono<Void> setAutoCommit(boolean autoCommit) {
        Mono mono = Mono.from((Publisher)this.connection.setAutoCommit(autoCommit));
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Connection autoCommit mode updated: autoCommit=?, class='?', id='?'.", (Object)autoCommit, (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    @Override
    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        Mono mono = Mono.from((Publisher)this.connection.setTransactionIsolationLevel(isolationLevel));
        if (this.logger.isTraceEnabled()) {
            return mono.doOnSuccess(s -> this.logger.trace((RequestIdSupplier)this, "Transaction isolation level updated: isolationLevel='?', class='?', id='?'.", (Object)isolationLevel, (Object)this.getConnectionClassName(), (Object)this.getConnectionId()));
        }
        return mono;
    }

    @Override
    public Mono<Boolean> validate(ValidationDepth depth) {
        return Mono.from((Publisher)this.connection.validate(depth));
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getConnectionId() {
        return "c" + System.identityHashCode(this.connection);
    }

    @Override
    public String getConnectionClassName() {
        return this.connection.getClass().getSimpleName();
    }
}

