/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.internal;

import io.r2dbc.spi.IsolationLevel;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.util.Requires;
import io.rxmicro.data.sql.model.SavePoint;
import io.rxmicro.data.sql.r2dbc.detail.RepositoryConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractTransaction {
    private static final Map<io.rxmicro.data.sql.model.IsolationLevel, IsolationLevel> MAPPING = Map.of(io.rxmicro.data.sql.model.IsolationLevel.READ_COMMITTED, IsolationLevel.READ_COMMITTED, io.rxmicro.data.sql.model.IsolationLevel.READ_UNCOMMITTED, IsolationLevel.READ_UNCOMMITTED, io.rxmicro.data.sql.model.IsolationLevel.REPEATABLE_READ, IsolationLevel.REPEATABLE_READ, io.rxmicro.data.sql.model.IsolationLevel.SERIALIZABLE, IsolationLevel.SERIALIZABLE);
    private static final Map<IsolationLevel, io.rxmicro.data.sql.model.IsolationLevel> REVERSE_MAPPING = Map.of(IsolationLevel.READ_COMMITTED, io.rxmicro.data.sql.model.IsolationLevel.READ_COMMITTED, IsolationLevel.READ_UNCOMMITTED, io.rxmicro.data.sql.model.IsolationLevel.READ_UNCOMMITTED, IsolationLevel.REPEATABLE_READ, io.rxmicro.data.sql.model.IsolationLevel.REPEATABLE_READ, IsolationLevel.SERIALIZABLE, io.rxmicro.data.sql.model.IsolationLevel.SERIALIZABLE);
    private final RepositoryConnection connection;
    private List<SavePoint> savePoints = List.of();
    private boolean active;

    protected AbstractTransaction(RepositoryConnection connection) {
        this.connection = (RepositoryConnection)Requires.require((Object)connection);
        this.active = true;
    }

    RepositoryConnection getConnection() {
        return this.connection;
    }

    protected Publisher<Void> baseCommit() {
        this.checkActive();
        this.active = false;
        return Mono.from(this.connection.commitTransaction()).then(Mono.from(this.connection.close()));
    }

    protected Publisher<Void> baseRollback() {
        this.checkActive();
        this.active = false;
        return Mono.from(this.connection.rollbackTransaction()).then(Mono.from(this.connection.close()));
    }

    protected Publisher<Void> baseRollback(SavePoint savePoint) {
        SavePoint previous;
        this.checkActive();
        if (!this.savePoints.contains(savePoint)) {
            throw new IllegalArgumentException("Save point not defined: " + savePoint);
        }
        ListIterator<SavePoint> listIterator = this.savePoints.listIterator(this.savePoints.size());
        while (listIterator.hasPrevious() && !savePoint.equals((Object)(previous = listIterator.previous()))) {
            listIterator.remove();
        }
        return this.connection.rollbackTransaction();
    }

    protected Publisher<Void> baseCreate(SavePoint savePoint) {
        this.checkActive();
        if (this.savePoints.getClass() == List.of().getClass()) {
            this.savePoints = new ArrayList<SavePoint>();
        } else if (this.savePoints.contains(savePoint)) {
            throw new IllegalArgumentException("Save point already defined: " + savePoint);
        }
        this.savePoints.add(savePoint);
        return this.connection.createSavepoint(savePoint.getName());
    }

    protected Publisher<Void> baseRelease(SavePoint savePoint) {
        this.checkActive();
        if (!this.savePoints.remove(savePoint)) {
            throw new IllegalArgumentException("Save point not defined: " + savePoint);
        }
        return this.connection.releaseSavepoint(savePoint.getName());
    }

    public final io.rxmicro.data.sql.model.IsolationLevel getIsolationLevel() {
        this.checkActive();
        return REVERSE_MAPPING.getOrDefault(this.connection.getTransactionIsolationLevel(), io.rxmicro.data.sql.model.IsolationLevel.READ_COMMITTED);
    }

    protected Publisher<Void> baseSetIsolationLevel(io.rxmicro.data.sql.model.IsolationLevel isolationLevel) {
        this.checkActive();
        return this.connection.setTransactionIsolationLevel(MAPPING.get(Requires.require((Object)isolationLevel)));
    }

    protected final void checkActive() {
        if (!this.active) {
            throw new InvalidStateException("Current transaction is not active!");
        }
    }
}

