/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.detail;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.rxmicro.data.sql.r2dbc.detail.RepositoryConnection;
import io.rxmicro.data.sql.r2dbc.detail.RepositoryConnectionFactory;
import io.rxmicro.data.sql.r2dbc.internal.RepositoryConnectionImpl;
import io.rxmicro.logger.RequestIdSupplier;
import reactor.core.publisher.Mono;

public final class RepositoryConnectionPool
implements RepositoryConnectionFactory {
    private final Class<?> repositoryInterface;
    private final ConnectionPool pool;

    public RepositoryConnectionPool(Class<?> repositoryInterface, ConnectionPool pool) {
        this.repositoryInterface = repositoryInterface;
        this.pool = pool;
    }

    @Override
    public Mono<RepositoryConnection> create() {
        return this.pool.create().map(c -> new RepositoryConnectionImpl(this.repositoryInterface, (Connection)c));
    }

    @Override
    public Mono<RepositoryConnection> create(RequestIdSupplier requestIdSupplier) {
        return this.pool.create().map(c -> new RepositoryConnectionImpl(this.repositoryInterface, (Connection)c, requestIdSupplier.getRequestId()));
    }

    public ConnectionFactoryMetadata getMetadata() {
        return this.pool.getMetadata();
    }
}

