/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.detail;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.rxmicro.data.sql.detail.AbstractSQLRepository;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import io.rxmicro.data.sql.model.reactor.Transaction;
import io.rxmicro.data.sql.r2dbc.detail.RepositoryConnection;
import io.rxmicro.data.sql.r2dbc.internal.Connections;
import io.rxmicro.data.sql.r2dbc.internal.ResultConverters;
import io.rxmicro.data.sql.r2dbc.internal.Statements;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public abstract class AbstractR2DBCRepository
extends AbstractSQLRepository {
    private final Connections connections = new Connections();
    private final Statements statements = new Statements(this.logger);

    protected AbstractR2DBCRepository(Class<?> repositoryInterface) {
        super(repositoryInterface);
    }

    protected final Mono<RepositoryConnection> extractConnectionFrom(Transaction transaction) {
        return this.connections.extractConnectionFrom(transaction);
    }

    protected final Mono<RepositoryConnection> extractConnectionFrom(io.rxmicro.data.sql.model.rxjava3.Transaction transaction) {
        return this.connections.extractConnectionFrom(transaction);
    }

    protected final Mono<RepositoryConnection> extractConnectionFrom(io.rxmicro.data.sql.model.completablefuture.Transaction transaction) {
        return this.connections.extractConnectionFrom(transaction);
    }

    protected final Mono<Transaction> beginReactorTransaction(RepositoryConnection connection) {
        return this.connections.beginReactorTransaction(connection);
    }

    protected final Mono<io.rxmicro.data.sql.model.rxjava3.Transaction> beginRxJava3Transaction(RepositoryConnection connection) {
        return this.connections.beginRxJava3Transaction(connection);
    }

    protected final Mono<io.rxmicro.data.sql.model.completablefuture.Transaction> beginCompletableFutureTransaction(RepositoryConnection connection) {
        return this.connections.beginCompletableFutureTransaction(connection);
    }

    protected final Mono<Void> close(RepositoryConnection connection) {
        return this.connections.close(connection);
    }

    protected final <T> Function<Throwable, Mono<T>> createCloseThenReturnErrorFallback(RepositoryConnection connection) {
        return throwable -> this.connections.close(connection).then(Mono.error((Throwable)throwable));
    }

    protected final Mono<? extends Result> executeStatement(RepositoryConnection connection, String sql) {
        return this.statements.executeStatement(connection, sql);
    }

    protected final Mono<? extends Result> executeStatement(RepositoryConnection connection, String sql, Object ... params) {
        return this.statements.executeStatement(connection, sql, params);
    }

    protected final Mono<? extends Result> executeStatement(RepositoryConnection connection, String sql, Object[] params, Class<?>[] types) {
        return this.statements.executeStatement(connection, sql, params, types);
    }

    protected final BiFunction<Row, RowMetadata, EntityFieldMap> toEntityFieldMap() {
        return ResultConverters.TO_ENTITY_FIELD_MAP_BI_FUNCTION;
    }

    protected final BiFunction<Row, RowMetadata, EntityFieldList> toEntityFieldList() {
        return ResultConverters.TO_ENTITY_FIELD_LIST_BI_FUNCTION;
    }
}

