/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.util.Requires;

public final class UrlPaths {
    public static final String TO_REMOVE_CHARACTERS = " \t\n\r";

    public static String normalizeUrlPath(String path) {
        Requires.require(path);
        StringBuilder pathBuilder = new StringBuilder();
        if (path.isEmpty() || path.charAt(0) != '/') {
            pathBuilder.append('/');
        }
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (TO_REMOVE_CHARACTERS.indexOf(ch) != -1) continue;
            if (ch == '/') {
                if (pathBuilder.length() == 0) {
                    pathBuilder.append('/');
                    continue;
                }
                if (pathBuilder.charAt(pathBuilder.length() - 1) == '/') continue;
                pathBuilder.append('/');
                continue;
            }
            pathBuilder.append(ch);
        }
        int lastIndex = pathBuilder.length() - 1;
        if (lastIndex > 0 && pathBuilder.charAt(lastIndex) == '/') {
            pathBuilder.deleteCharAt(lastIndex);
        }
        return pathBuilder.toString();
    }

    private UrlPaths() {
    }
}

