/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public final class Strings {
    private static final int HEX_CODE_LENGTH = 4;

    public static String capitalize(String string) {
        if (string.length() > 1) {
            if (Character.isUpperCase(string.charAt(0))) {
                return string;
            }
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        if (string.length() == 1) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        return string;
    }

    public static String unCapitalize(String string) {
        if (string.length() > 1) {
            if (Character.isLowerCase(string.charAt(0))) {
                return string;
            }
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        if (string.length() == 1) {
            return string.toLowerCase(Locale.ENGLISH);
        }
        return string;
    }

    public static List<String> splitByCamelCase(String variableName) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder wordBuilder = new StringBuilder();
        for (int i = 0; i < variableName.length(); ++i) {
            char ch = variableName.charAt(i);
            if (Character.isUpperCase(ch) && wordBuilder.length() > 0) {
                list.add(wordBuilder.toString());
                wordBuilder.delete(0, wordBuilder.length());
            }
            wordBuilder.append(ch);
        }
        if (wordBuilder.length() > 0) {
            list.add(wordBuilder.toString());
        }
        return Strings.collectAbbreviation(list);
    }

    private static List<String> collectAbbreviation(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = list.iterator();
        StringBuilder abbreviationBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            String word = iterator.next();
            if (word.length() == 1 && Character.isUpperCase(word.charAt(0))) {
                abbreviationBuilder.append(word);
                continue;
            }
            if (abbreviationBuilder.length() > 0) {
                result.add(abbreviationBuilder.toString());
                abbreviationBuilder.delete(0, abbreviationBuilder.length());
            }
            result.add(word);
        }
        if (abbreviationBuilder.length() > 0) {
            result.add(abbreviationBuilder.toString());
            abbreviationBuilder.delete(0, abbreviationBuilder.length());
        }
        return result;
    }

    public static List<String> split(String source, String delimiter) {
        if (source == null || source.isEmpty()) {
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(source, delimiter);
        while (stringTokenizer.hasMoreTokens()) {
            result.add(stringTokenizer.nextToken());
        }
        return Collections.unmodifiableList(result);
    }

    public static String escapeString(String original) {
        StringBuilder resultBuilder = new StringBuilder();
        Strings.escapeString(resultBuilder, original);
        return resultBuilder.toString();
    }

    public static void escapeString(StringBuilder resultBuilder, String original) {
        for (int i = 0; i < original.length(); ++i) {
            char ch = original.charAt(i);
            if (ch == '\\' || ch == '\"') {
                resultBuilder.append('\\').append(ch);
                continue;
            }
            if (ch == '\b') {
                resultBuilder.append("\\b");
                continue;
            }
            if (ch == '\t') {
                resultBuilder.append("\\t");
                continue;
            }
            if (ch == '\n') {
                resultBuilder.append("\\n");
                continue;
            }
            if (ch == '\f') {
                resultBuilder.append("\\f");
                continue;
            }
            if (ch == '\r') {
                resultBuilder.append("\\r");
                continue;
            }
            if (ch < ' ' || ch >= '\u0080' && ch < '\u00a0' || ch >= '\u2000' && ch < '\u2100') {
                resultBuilder.append("\\u");
                String hexCode = Integer.toHexString(ch);
                resultBuilder.append("0000", 0, 4 - hexCode.length());
                resultBuilder.append(hexCode);
                continue;
            }
            resultBuilder.append(ch);
        }
    }

    public static boolean startsWith(String string, char prefix) {
        return !string.isEmpty() && string.charAt(0) == prefix;
    }

    private Strings() {
    }
}

