/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.util.Formats;
import java.util.Arrays;
import java.util.function.Supplier;

public final class Requires {
    public static <T> T require(T instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        return instance;
    }

    public static <T> T require(T instance, String message, Object ... args) {
        if (instance == null) {
            throw new NullPointerException(Formats.format(message, args));
        }
        return instance;
    }

    @SafeVarargs
    public static <T> T require(T instance, String message, Supplier<Object> ... suppliers) {
        if (instance == null) {
            throw new NullPointerException(Formats.format(message, Arrays.stream(suppliers).map(Supplier::get).toArray()));
        }
        return instance;
    }

    private Requires() {
    }
}

