/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.util.Environments;
import io.rxmicro.common.util.Requires;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Formats {
    public static final char FORMAT_PLACEHOLDER_CHAR = '?';
    public static final String FORMAT_PLACEHOLDER_TOKEN = String.valueOf('?');
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final boolean IS_CURRENT_OS_WINDOWS = Environments.isCurrentOsWindows();
    private static final int BYTES_IN_1_KIB = 1024;
    private static final int NANOS_IN_1_MILLIS = (int)TimeUnit.MILLISECONDS.toNanos(1L);

    public static String format(String messageTemplate, Object ... args) {
        if (args.length == 0) {
            return Formats.formatWithoutArguments(messageTemplate);
        }
        return Formats.formatWithArguments(messageTemplate, args);
    }

    public static String format(Duration duration) {
        if (duration.getSeconds() == 0L) {
            return (double)duration.getNano() / (double)NANOS_IN_1_MILLIS + "ms";
        }
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase(Locale.ENGLISH);
    }

    public static String formatSize(long size, boolean withOriginalValue) {
        ArrayList<String> parts = new ArrayList<String>();
        for (long current = size; current > 0L; current /= 1024L) {
            long value = current % 1024L;
            parts.add(String.valueOf(value));
        }
        String originalFragment = withOriginalValue ? " (" + NumberFormat.getNumberInstance().format(size) + " bytes)" : "";
        return (String)parts.get(parts.size() - 1) + " " + Formats.getUnits(parts) + originalFragment;
    }

    public static String formatSize(long size) {
        return Formats.formatSize(size, true);
    }

    private static String formatWithoutArguments(String messageTemplate) {
        if (IS_CURRENT_OS_WINDOWS) {
            StringBuilder sb = new StringBuilder(messageTemplate.length());
            for (int i = 0; i < messageTemplate.length(); ++i) {
                char ch = messageTemplate.charAt(i);
                if (ch == '\n') {
                    sb.append(LINE_SEPARATOR);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return Requires.require(messageTemplate);
    }

    private static String formatWithArguments(String messageTemplate, Object ... args) {
        StringBuilder sb = new StringBuilder(messageTemplate.length() * 3 / 2);
        int index = 0;
        try {
            for (int i = 0; i < messageTemplate.length(); ++i) {
                char ch = messageTemplate.charAt(i);
                if (ch == '\n') {
                    sb.append(LINE_SEPARATOR);
                    continue;
                }
                if (ch == '?') {
                    sb.append(args[index++]);
                    continue;
                }
                sb.append(ch);
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new IllegalArgumentException("Redundant placeholder or missing argument: {{" + messageTemplate + "}} with " + Arrays.toString(args));
        }
        if (index != args.length) {
            throw new IllegalArgumentException("Missing placeholder or redundant argument: {{" + messageTemplate + "}} with " + Arrays.toString(args));
        }
        return sb.toString();
    }

    private static String getUnits(List<String> parts) {
        switch (parts.size()) {
            case 1: {
                return "bytes";
            }
            case 2: {
                return "Kb";
            }
            case 3: {
                return "Mb";
            }
            case 4: {
                return "Gb";
            }
            case 5: {
                return "Tb";
            }
        }
        throw new IllegalArgumentException("Unsupported units");
    }

    private Formats() {
    }
}

