/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.CheckedWrapperException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletionException;

public final class Exceptions {
    public static <T> T reThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new CheckedWrapperException(throwable);
    }

    public static boolean isInstanceOf(Throwable throwable, Class<? extends Throwable> exceptionType) {
        if (throwable != null) {
            if (exceptionType.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            if (throwable instanceof CompletionException) {
                return Exceptions.getCause(throwable, CompletionException.class).map(th -> exceptionType.isAssignableFrom(th.getClass())).orElse(false);
            }
            if (throwable instanceof CheckedWrapperException) {
                return Exceptions.getCause(throwable, CheckedWrapperException.class).map(th -> exceptionType.isAssignableFrom(th.getClass())).orElse(false);
            }
        }
        return false;
    }

    @SafeVarargs
    public static Optional<Throwable> getCause(Throwable throwable, Class<? extends Throwable> ... containerExceptionClasses) {
        Throwable result;
        for (result = throwable.getCause(); result != null; result = result.getCause()) {
            Throwable throwableInstance = result;
            if (Arrays.stream(containerExceptionClasses).noneMatch(e -> e.isAssignableFrom(throwableInstance.getClass()))) break;
        }
        return Optional.ofNullable(result);
    }

    public static Throwable getRealThrowable(Throwable throwable) {
        return Exceptions.getCause(throwable, CompletionException.class, CheckedWrapperException.class).orElse(throwable);
    }

    private Exceptions() {
    }
}

