/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class ExCollectors {
    public static <T, K, U> Collector<T, ?, Map<K, U>> toOrderedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, ExCollectors.throwingMerger(), LinkedHashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toUnmodifiableOrderedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(ExCollectors.toOrderedMap(keyMapper, valueMapper), map -> ExCollections.unmodifiableOrderedMap(map));
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toTreeMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, ExCollectors.throwingMerger(), TreeMap::new);
    }

    public static <T> Collector<T, ?, Set<T>> toOrderedSet() {
        return Collectors.toCollection(LinkedHashSet::new);
    }

    public static <T> Collector<T, ?, Set<T>> toTreeSet() {
        return Collectors.toCollection(TreeSet::new);
    }

    public static <T> Collector<T, ?, Set<T>> toTreeSet(Comparator<T> comparator) {
        return Collectors.toCollection(() -> new TreeSet(comparator));
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableTreeSet() {
        return Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), ExCollections::unmodifiableOrderedSet);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableOrderedSet() {
        return Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), ExCollections::unmodifiableOrderedSet);
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalArgumentException(Formats.format("Duplicate key ?", u));
        };
    }

    private ExCollectors() {
    }
}

