/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.util.Formats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ExCollections {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set<Class<? extends Map>> UNMODIFIABLE_MAP_CLASSES = Set.of(Collections.unmodifiableMap(Map.of()).getClass(), Map.of().getClass(), Map.of(1, 1).getClass());
    private static final Set<Class<? extends Set>> UNMODIFIABLE_SET_CLASSES = Set.of(Collections.unmodifiableSet(Set.of()).getClass(), Set.of().getClass(), Set.of(Integer.valueOf(1)).getClass());
    private static final Set<Class<? extends List>> UNMODIFIABLE_LIST_CLASSES = Set.of(Collections.unmodifiableList(List.of()).getClass(), List.of().getClass(), List.of(Integer.valueOf(1)).getClass());

    public static boolean isUnmodifiableList(Object object) {
        return object != null && UNMODIFIABLE_LIST_CLASSES.contains(object.getClass());
    }

    public static <E> List<E> unmodifiableList(Collection<E> collection) {
        if (collection.isEmpty()) {
            return List.of();
        }
        if (UNMODIFIABLE_LIST_CLASSES.contains(collection.getClass())) {
            return (List)collection;
        }
        if (collection.size() == 1) {
            return List.of(collection.iterator().next());
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableList(new ArrayList<E>(collection));
    }

    public static boolean isUnmodifiableMap(Object object) {
        return object != null && UNMODIFIABLE_MAP_CLASSES.contains(object.getClass());
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        return ExCollections.unmodifiableOrderedMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableOrderedMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Map.of();
        }
        if (UNMODIFIABLE_MAP_CLASSES.contains(map.getClass())) {
            return map;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Map.of(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <E> Set<E> unmodifiableOrderedSet(Collection<E> collection) {
        if (collection.isEmpty()) {
            return Set.of();
        }
        if (UNMODIFIABLE_SET_CLASSES.contains(collection.getClass())) {
            return (Set)collection;
        }
        if (collection.size() == 1) {
            return Set.of(collection.iterator().next());
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(collection));
    }

    @SafeVarargs
    public static <E> Set<E> unmodifiableOrderedSet(E ... elements) {
        return ExCollections.unmodifiableOrderedSet(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <E> Set<E> join(Set<E> ... items) {
        return Arrays.stream(items).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <E> List<E> join(List<E> ... items) {
        return Arrays.stream(items).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4), Map.entry(k5, v5));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4), Map.entry(k5, v5), Map.entry(k6, v6));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4), Map.entry(k5, v5), Map.entry(k6, v6), Map.entry(k7, v7));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4), Map.entry(k5, v5), Map.entry(k6, v6), Map.entry(k7, v7), Map.entry(k8, v8));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4), Map.entry(k5, v5), Map.entry(k6, v6), Map.entry(k7, v7), Map.entry(k8, v8), Map.entry(k9, v9));
    }

    public static <K, V> Map<K, V> orderedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return ExCollections.orderedMapFromEntries(Map.entry(k1, v1), Map.entry(k2, v2), Map.entry(k3, v3), Map.entry(k4, v4), Map.entry(k5, v5), Map.entry(k6, v6), Map.entry(k7, v7), Map.entry(k8, v8), Map.entry(k9, v9), Map.entry(k10, v10));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> orderedMapFromEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            V oldValue = map.put(entry.getKey(), entry.getValue());
            if (oldValue == null) continue;
            throw new IllegalArgumentException(Formats.format("Duplicate detected: key=?, value1=?, value2=?", entry.getKey(), entry.getValue(), oldValue));
        }
        return ExCollections.unmodifiableMap(map);
    }

    private ExCollections() {
    }
}

