/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.util;

import io.rxmicro.common.model.StringIterator;
import io.rxmicro.common.util.Formats;
import java.util.Locale;
import java.util.Map;

public final class Environments {
    private static final String OS_NAME = "os.name";
    private static final String UNKNOWN = "unknown";

    public static boolean isCurrentOsMac() {
        return System.getProperty(OS_NAME, UNKNOWN).toLowerCase(Locale.ENGLISH).contains("mac");
    }

    public static boolean isCurrentOsLinux() {
        return System.getProperty(OS_NAME, UNKNOWN).toLowerCase(Locale.ENGLISH).contains("linux");
    }

    public static boolean isCurrentOsWindows() {
        return System.getProperty(OS_NAME, UNKNOWN).toLowerCase(Locale.ENGLISH).contains("windows");
    }

    public static String resolveEnvironmentVariables(String expression) {
        return Environments.resolveVariables(expression, System.getenv());
    }

    public static String resolveVariables(String expression, Map<String, String> variableValues) {
        StringBuilder stringBuilder = new StringBuilder(expression.length());
        StringIterator iterator = new StringIterator(expression);
        Environments.resolve(variableValues, stringBuilder, iterator);
        return stringBuilder.toString();
    }

    private static void resolve(Map<String, String> variableValues, StringBuilder stringBuilder, StringIterator iterator) {
        while (iterator.next()) {
            char ch = iterator.getCurrent();
            if ('$' == ch) {
                String variableName = Environments.readVariableName(iterator);
                String value = variableValues.get(variableName);
                if (value == null) {
                    throw new IllegalArgumentException(Formats.format("Invalid expression: '?'. Variable '?' not defined!", iterator.getSource(), variableName));
                }
                stringBuilder.append(value);
                continue;
            }
            if ('{' == ch || '}' == ch) {
                throw new IllegalArgumentException(Formats.format("Invalid expression: '?'. Missing '$' at ? position", iterator.getSource(), iterator.getIndex()));
            }
            stringBuilder.append(ch);
        }
    }

    private static String readVariableName(StringIterator iterator) {
        char ch;
        if (iterator.next() && '{' == (ch = iterator.getCurrent())) {
            int start = iterator.getIndex() + 1;
            while (iterator.next()) {
                if ('}' != iterator.getCurrent()) continue;
                int end = iterator.getIndex();
                if (end > start) {
                    return iterator.getSource().substring(start, end);
                }
                throw new IllegalArgumentException(Formats.format("Invalid expression: '?'. Missing variable name at ? position!", iterator.getSource(), end));
            }
            throw new IllegalArgumentException(Formats.format("Invalid expression: '?'. Missing '}'", iterator.getSource()));
        }
        throw new IllegalArgumentException(Formats.format("Invalid expression: '?'. Expected '{' after '$' at ? position!", iterator.getSource(), iterator.getIndex()));
    }

    private Environments() {
    }
}

