/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.model;

public final class StringIterator {
    public static final char NO_MORE_CHARACTERS_PRESENT = '\u0000';
    private final String string;
    private final int length;
    private int index;

    public StringIterator(String string) {
        this(string, true);
    }

    public StringIterator(String string, boolean startFromFirstCharacter) {
        this.string = string;
        this.length = string.length();
        this.index = startFromFirstCharacter ? -1 : this.length;
    }

    public boolean next() {
        return ++this.index < this.string.length();
    }

    public char getCurrent() {
        if (this.index < this.length) {
            return this.string.charAt(this.index);
        }
        return '\u0000';
    }

    public char getPrevious() {
        if (this.index > 0) {
            return this.string.charAt(this.index - 1);
        }
        return '\u0000';
    }

    public char getNext() {
        if (this.index < this.length - 1) {
            return this.string.charAt(this.index + 1);
        }
        return '\u0000';
    }

    public boolean previous() {
        return --this.index >= 0;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSource() {
        return this.string;
    }

    public String toString() {
        return "StringIterator{string='" + this.string + "', index=" + this.index + "}";
    }
}

