/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common.model;

import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder<K, V> {
    private final Map<K, V> map = new LinkedHashMap();
    private final boolean withoutDuplicates;
    private boolean built;

    public MapBuilder(boolean withoutDuplicates) {
        this.withoutDuplicates = withoutDuplicates;
    }

    public MapBuilder() {
        this(false);
    }

    public MapBuilder<K, V> put(K name, V value) {
        if (this.built) {
            throw new InvalidStateException("This builder can't be used, because the map instance already built! Create a new builder!");
        }
        V oldValue = this.map.put(name, value);
        if (this.withoutDuplicates && oldValue != null) {
            throw new IllegalArgumentException(Formats.format("Duplicate detected: name=?, value1=?, value2=?", name, value, oldValue));
        }
        return this;
    }

    public Map<K, V> build() {
        this.built = true;
        return ExCollections.unmodifiableOrderedMap(this.map);
    }
}

