/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.common;

import java.util.Arrays;
import java.util.Optional;

public enum RxMicroModule {
    RX_MICRO_COMMON_MODULE("rxmicro.common"),
    RX_MICRO_REFLECTION_MODULE("rxmicro.reflection"),
    RX_MICRO_MODEL_MODULE("rxmicro.model"),
    RX_MICRO_CONFIG_MODULE("rxmicro.config"),
    RX_MICRO_LOGGER_MODULE("rxmicro.logger"),
    RX_MICRO_RUNTIME_MODULE("rxmicro.runtime"),
    RX_MICRO_RESOURCE_MODULE("rxmicro.resource"),
    RX_MICRO_NETTY_RUNTIME_MODULE("rxmicro.netty.runtime"),
    RX_MICRO_NETTY_NATIVE_MODULE("rxmicro.netty.native"),
    RX_MICRO_NETTY_NATIVE_ALL_MODULE("rxmicro.netty.native.all"),
    RX_MICRO_NETTY_NATIVE_LINUX_MODULE("rxmicro.netty.native.linux"),
    RX_MICRO_NETTY_NATIVE_OSX_MODULE("rxmicro.netty.native.osx"),
    RX_MICRO_CDI_MODULE("rxmicro.cdi"),
    RX_MICRO_DATA_MODULE("rxmicro.data"),
    RX_MICRO_DATA_MONGO_MODULE("rxmicro.data.mongo"),
    RX_MICRO_DATA_SQL_MODULE("rxmicro.data.sql"),
    RX_MICRO_DATA_SQL_R2DBC_MODULE("rxmicro.data.sql.r2dbc"),
    RX_MICRO_DATA_SQL_R2DBC_POSTGRESQL_MODULE("rxmicro.data.sql.r2dbc.postgresql"),
    RX_MICRO_DOCUMENTATION_MODULE("rxmicro.documentation"),
    RX_MICRO_DOCUMENTATION_ASCIIDOCTOR_MODULE("rxmicro.documentation.asciidoctor"),
    RX_MICRO_HTTP_MODULE("rxmicro.http"),
    RX_MICRO_REST_MODULE("rxmicro.rest"),
    RX_MICRO_REST_CLIENT_MODULE("rxmicro.rest.client"),
    RX_MICRO_REST_CLIENT_JDK_MODULE("rxmicro.rest.client.jdk"),
    RX_MICRO_REST_CLIENT_NETTY_MODULE("rxmicro.rest.client.netty"),
    RX_MICRO_REST_SERVER_MODULE("rxmicro.rest.server"),
    RX_MICRO_REST_SERVER_NETTY_MODULE("rxmicro.rest.server.netty"),
    RX_MICRO_JSON_MODULE("rxmicro.json"),
    RX_MICRO_EXCHANGE_JSON_MODULE("rxmicro.exchange.json"),
    RX_MICRO_REST_CLIENT_EXCHANGE_JSON_MODULE("rxmicro.rest.client.exchange.json"),
    RX_MICRO_REST_SERVER_EXCHANGE_JSON_MODULE("rxmicro.rest.server.exchange.json"),
    RX_MICRO_MONITORING_MODULE("rxmicro.monitoring"),
    RX_MICRO_VALIDATION_MODULE("rxmicro.validation"),
    RX_MICRO_TOOL_COMMON_MODULE("rxmicro.tool.common"),
    RX_MICRO_TEST_MODULE("rxmicro.test"),
    RX_MICRO_TEST_DBUNIT_MODULE("rxmicro.test.dbunit"),
    RX_MICRO_TEST_DBUNIT_JUNIT_MODULE("rxmicro.test.dbunit.junit"),
    RX_MICRO_TEST_JUNIT_MODULE("rxmicro.test.junit"),
    RX_MICRO_TEST_MOCKITO_MODULE("rxmicro.test.mockito"),
    RX_MICRO_TEST_MOCKITO_JUNIT_MODULE("rxmicro.test.mockito.junit"),
    RX_MICRO_SLF4J_PROXY_MODULE("rxmicro.slf4j.proxy");

    private final String name;

    public static boolean isSqlR2DBCModule(String moduleFullName) {
        return moduleFullName.contains("rxmicro.data.sql.r2dbc.");
    }

    public static Optional<RxMicroModule> of(String moduleFullName) {
        for (RxMicroModule rxMicroModule : RxMicroModule.values()) {
            if (!rxMicroModule.name.equals(moduleFullName)) continue;
            return Optional.of(rxMicroModule);
        }
        return Optional.empty();
    }

    public static boolean isRxMicroPackage(String packageName) {
        return Arrays.stream(RxMicroModule.values()).anyMatch(module -> module.getRootPackage().equals(packageName) || packageName.startsWith(module.getRootPackage() + "."));
    }

    private RxMicroModule(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getRootPackage() {
        return "io." + this.name;
    }

    public String getDirectory() {
        return this.name.replace('.', '-');
    }

    public String toString() {
        return this.name;
    }
}

