/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.cdi.resource;

import io.rxmicro.cdi.resource.ResourceConverter;
import io.rxmicro.resource.model.ResourceException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public abstract class AbstractFileResourceConverter<D>
implements ResourceConverter<D> {
    @Override
    public final Optional<D> convert(String resourcePath) {
        String pathName = resourcePath.startsWith("file://") ? resourcePath.substring("file://".length()) : resourcePath;
        Path path = Paths.get(pathName, new String[0]);
        try {
            return this.convert(path);
        }
        catch (NoSuchFileException ex) {
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new ResourceException((Throwable)ex, "Can't read data from path: '?'", new Object[]{path.toAbsolutePath()});
        }
    }

    protected abstract Optional<D> convert(Path var1) throws IOException;
}

