/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.cdi.internal;

import io.rxmicro.common.RxMicroException;
import io.rxmicro.common.util.Formats;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class CircularDependenciesResolver {
    private static final int MAX_DEPENDENCY_DEPTH = 50;
    private final Deque<Map.Entry<Object, String>> deque = new ArrayDeque<Map.Entry<Object, String>>();

    public void push(Object instance, String injectionPoint) {
        this.deque.push(Map.entry(instance, injectionPoint));
        if (this.deque.size() >= 50) {
            throw new CircularDependenciesDetectedException(String.join((CharSequence)";", this.getCircularDependencies()));
        }
    }

    private List<String> getCircularDependencies() {
        HashMap<String, AtomicInteger> countMap = new HashMap<String, AtomicInteger>();
        for (Map.Entry<Object, String> entry : this.deque) {
            AtomicInteger count = countMap.computeIfAbsent(Formats.format((String)"\n{Bean: '?', injection point: '?'", (Object[])new Object[]{entry.getKey().getClass().getName(), entry.getValue()}), k -> new AtomicInteger(0));
            count.incrementAndGet();
        }
        return countMap.entrySet().stream().sorted((o1, o2) -> Integer.compare(((AtomicInteger)o2.getValue()).get(), ((AtomicInteger)o1.getValue()).get())).map(e -> Formats.format((String)"?, circular dependencies marker: ?}", (Object[])new Object[]{e.getKey(), ((AtomicInteger)e.getValue()).get()})).collect(Collectors.toList());
    }

    public void pop() {
        this.deque.pop();
    }

    private static final class CircularDependenciesDetectedException
    extends RxMicroException {
        private CircularDependenciesDetectedException(Object ... args) {
            super(false, false, "The following beans contain the circular dependencies: \n?.\n\nRemove these circular dependencies!", args);
        }
    }
}

