/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.cdi.detail;

import io.rxmicro.cdi.resource.ResourceConverter;
import io.rxmicro.common.util.Environments;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.resource.model.ResourceException;
import java.util.Optional;

public final class ResourceLoaderFactory {
    public static <R> Optional<R> loadOptionalResource(String resourcePath, Class<? extends ResourceConverter<R>> converterClass) {
        ResourceConverter converter = (ResourceConverter)Reflections.instantiate(converterClass);
        return converter.convert(Environments.resolveEnvironmentVariables((String)resourcePath));
    }

    public static <R> R loadResource(String resourcePath, Class<? extends ResourceConverter<R>> converterClass) {
        return ResourceLoaderFactory.loadOptionalResource(resourcePath, converterClass).orElseThrow(() -> {
            throw new ResourceException("Resource '?' not found", new Object[]{resourcePath});
        });
    }

    private ResourceLoaderFactory() {
    }
}

