/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.cdi.detail;

import io.rxmicro.cdi.BeanFactory;
import io.rxmicro.cdi.internal.CircularDependenciesResolver;
import io.rxmicro.runtime.detail.InstanceQualifier;
import io.rxmicro.runtime.local.AbstractFactory;
import io.rxmicro.runtime.local.InstanceContainer;
import io.rxmicro.runtime.local.error.InstanceNotFoundException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;

public abstract class InternalBeanFactory
extends BeanFactory {
    private static final CircularDependenciesResolver CIRCULAR_DEPENDENCIES_RESOLVER = new CircularDependenciesResolver();

    @SafeVarargs
    public static <T> T getRequiredBean(Object instance, String injectionPoint, InstanceQualifier<? super T> ... instanceQualifiers) {
        return InternalBeanFactory.getOptionalBean(instance, injectionPoint, instanceQualifiers).orElseThrow(() -> {
            throw new InstanceNotFoundException("Can't inject bean qualified by '?' into '?.?': Bean not found.", new Object[]{Arrays.toString(instanceQualifiers), instance.getClass().getName(), injectionPoint});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static <T> Optional<T> getOptionalBean(Object instance, String injectionPoint, InstanceQualifier<? super T> ... instanceQualifiers) {
        AbstractFactory factory = InternalBeanFactory.get((String)BEAN_FACTORY_IMPL_CLASS_NAME);
        CIRCULAR_DEPENDENCIES_RESOLVER.push(instance, injectionPoint);
        try {
            Optional optional = Arrays.stream(instanceQualifiers).flatMap(q -> factory.getImpl(q).stream()).findFirst();
            return optional;
        }
        finally {
            CIRCULAR_DEPENDENCIES_RESOLVER.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> getBeansByType(Object instance, String injectionPoint, Class<T> interfaceType) {
        CIRCULAR_DEPENDENCIES_RESOLVER.push(instance, injectionPoint);
        try {
            Set set = InstanceContainer.getSingletonsByType(interfaceType);
            return set;
        }
        finally {
            CIRCULAR_DEPENDENCIES_RESOLVER.pop();
        }
    }
}

