/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor;

import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.BaseRxMicroAnnotationProcessor;
import io.rxmicro.annotation.processor.common.FormatSourceCodeDependenciesModule;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.AnnotationProcessorType;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.TestLoggers;
import io.rxmicro.reflection.ReflectionConstants;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public final class RxMicroTestsAnnotationProcessor
extends BaseRxMicroAnnotationProcessor {
    public RxMicroTestsAnnotationProcessor() {
        super((AbstractModuleClassStructuresBuilder)new TestModuleClassStructuresBuilder());
    }

    protected AnnotationProcessorType getAnnotationProcessorType() {
        return AnnotationProcessorType.TESTS_COMPILE;
    }

    private static final class IntegrationTestFixerClassStructure
    extends TestFixerClassStructure {
        private IntegrationTestFixerClassStructure() {
        }

        @Override
        protected String getSimpleClassName() {
            return "$$IntegrationTestFixer";
        }

        public String getTemplateName() {
            return "test/$$IntegrationTestFixerTemplate.javaftl";
        }
    }

    private static final class RestBasedMicroServiceTestFixerClassStructure
    extends TestFixerClassStructure {
        private RestBasedMicroServiceTestFixerClassStructure() {
        }

        @Override
        protected String getSimpleClassName() {
            return "$$RestBasedMicroServiceTestFixer";
        }

        public String getTemplateName() {
            return "test/$$RestBasedMicroServiceTestFixerTemplate.javaftl";
        }
    }

    private static final class ComponentTestFixerClassStructure
    extends TestFixerClassStructure {
        private ComponentTestFixerClassStructure() {
        }

        @Override
        protected String getSimpleClassName() {
            return "$$ComponentTestFixer";
        }

        public String getTemplateName() {
            return "test/$$ComponentTestFixerTemplate.javaftl";
        }
    }

    private static abstract class TestFixerClassStructure
    extends ClassStructure {
        private TestFixerClassStructure() {
        }

        protected abstract String getSimpleClassName();

        public final String getTargetFullClassName() {
            return GeneratedClassNames.getEntryPointFullClassName((String)this.getSimpleClassName());
        }

        public final Map<String, Object> getTemplateVariables() {
            return Map.of("PACKAGE_NAME", "rxmicro", "JAVA_CLASS_NAME", this.getSimpleClassName());
        }

        public final ClassHeader getClassHeader() {
            ClassHeader.Builder builder = ClassHeader.newClassHeaderBuilder((String)"rxmicro");
            this.customizeClassHeader(builder);
            return builder.addImports(new Class[]{Set.class}).addStaticImport(Formats.class, "format").addStaticImport(ReflectionConstants.class, "RX_MICRO_REFLECTION_MODULE").addStaticImport(TestLoggers.class, "logInfoTestMessage").addStaticImport(ExCollections.class, "unmodifiableOrderedSet").build();
        }

        protected void customizeClassHeader(ClassHeader.Builder builder) {
        }
    }

    private static final class TestModuleClassStructuresBuilder
    extends AbstractModuleClassStructuresBuilder {
        private final Map<String, ClassStructure> testFixerMap = Map.of("io.rxmicro.test.junit.RxMicroRestBasedMicroServiceTest", new RestBasedMicroServiceTestFixerClassStructure(), "io.rxmicro.test.junit.RxMicroIntegrationTest", new IntegrationTestFixerClassStructure(), "io.rxmicro.test.junit.RxMicroComponentTest", new ComponentTestFixerClassStructure());

        private TestModuleClassStructuresBuilder() {
            Injects.injectDependencies((Object)((Object)this), (Module[])new Module[]{new FormatSourceCodeDependenciesModule()});
        }

        public String getBuilderName() {
            return "test-fixer-annotation-processor-module";
        }

        public Set<String> getSupportedAnnotationTypes() {
            return this.testFixerMap.keySet();
        }

        protected Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (environmentContext.getCurrentModule().isUnnamed()) {
                return Set.of();
            }
            return annotations.stream().map(a -> this.testFixerMap.get(a.getQualifiedName().toString())).collect(Collectors.toSet());
        }

        protected boolean isEnvironmentCustomizerMustBeGenerated() {
            return false;
        }
    }
}

