/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model.validator;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.WithParentClassStructure;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.validator.ModelFieldValidatorsInvoker;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidator;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorCreator;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorCreatorDescriptor;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.detail.StatelessValidators;
import io.rxmicro.validation.validator.RequiredConstraintValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;

public final class ModelValidatorClassStructure
extends ClassStructure
implements WithParentClassStructure<ModelValidatorClassStructure, RestModelField, RestObjectModelClass> {
    private final boolean optional;
    private final ClassHeader.Builder classHeaderBuilder;
    private final RestObjectModelClass modelClass;
    private final List<ModelValidatorCreator> modelValidatorCreators;
    private final List<ModelFieldValidatorsInvoker> modelFieldValidatorsInvokers;
    private final Set<String> stdValidatorClassImports;
    private final Set<ModelValidatorClassStructure> childrenValidators;
    private ModelValidatorClassStructure parent;

    private ModelValidatorClassStructure(boolean optional, ClassHeader.Builder classHeaderBuilder, RestObjectModelClass modelClass, List<ModelValidatorCreator> modelValidatorCreators, List<ModelFieldValidatorsInvoker> modelFieldValidatorsInvokers, Set<String> stdValidatorClassImports, Set<ModelValidatorClassStructure> childrenValidators) {
        this.optional = optional;
        this.classHeaderBuilder = classHeaderBuilder;
        this.modelClass = (RestObjectModelClass)((Object)Requires.require((Object)((Object)modelClass)));
        this.modelValidatorCreators = (List)Requires.require(modelValidatorCreators);
        this.modelFieldValidatorsInvokers = (List)Requires.require(modelFieldValidatorsInvokers);
        this.stdValidatorClassImports = new TreeSet<String>((Collection)Requires.require(stdValidatorClassImports));
        this.childrenValidators = (Set)Requires.require(childrenValidators);
    }

    public RestObjectModelClass getModelClass() {
        return this.modelClass;
    }

    public String getModelFullClassName() {
        return this.modelClass.getJavaFullClassName();
    }

    public boolean assignParent(ModelValidatorClassStructure parent) {
        this.parent = parent;
        return true;
    }

    public String getTargetFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.modelClass.getModelTypeElement(), ConstraintValidator.class);
    }

    public String getTemplateName() {
        return "rest/$$RestModelValidatorTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("JAVA_MODEL_CLASS", (Object)this.modelClass);
        map.put("OPTIONAL", this.optional);
        map.put("JAVA_MODEL_VALIDATOR_CREATORS", this.modelValidatorCreators);
        map.put("JAVA_MODEL_VALIDATOR_INVOKERS", this.modelFieldValidatorsInvokers);
        map.put("JAVA_MODEL_VALIDATOR_CHILDREN", this.childrenValidators);
        if (this.parent != null) {
            map.put("PARENT", this.parent.getTargetSimpleClassName());
            map.put("HAS_PARENT", true);
        } else {
            map.put("HAS_PARENT", false);
        }
        return map;
    }

    public ClassHeader getClassHeader() {
        this.classHeaderBuilder.addImports(this.stdValidatorClassImports.toArray(ExCollections.EMPTY_STRING_ARRAY)).addImports(new Class[]{HttpModelType.class, ValidationException.class, ConstraintValidator.class}).addImports((String[])this.childrenValidators.stream().map(v -> GeneratedClassNames.getModelTransformerFullClassName((TypeElement)v.getModelClass().getModelTypeElement(), ConstraintValidator.class)).toArray(String[]::new)).addStaticImport(StatelessValidators.class, "getStatelessValidator");
        if (this.parent != null) {
            this.classHeaderBuilder.addImports(new String[]{this.parent.getTargetFullClassName()});
        }
        if (this.isRequiredReflectionGetter()) {
            this.classHeaderBuilder.addStaticImport(GeneratedClassNames.REFLECTIONS_FULL_CLASS_NAME, "getFieldValue");
        }
        return this.classHeaderBuilder.build();
    }

    public boolean isRequiredReflectionGetter() {
        return this.modelClass.isReadReflectionRequired();
    }

    public static final class Builder {
        private static final String STANDARD_VALIDATOR_PACKAGE = Names.getPackageName((String)RequiredConstraintValidator.class.getName());
        private final ClassHeader.Builder classHeaderBuilder;
        private final RestObjectModelClass modelClass;
        private final List<ModelValidatorCreator> modelValidatorCreators = new ArrayList<ModelValidatorCreator>();
        private final Map<String, ModelValidatorCreator> stateLessValidatorMap = new LinkedHashMap<String, ModelValidatorCreator>();
        private final Map<RestModelField, List<ModelValidator>> modelFieldValidatorsMap = new LinkedHashMap<RestModelField, List<ModelValidator>>();
        private final Set<String> stdValidatorClassImports = new HashSet<String>();
        private final Set<ModelValidatorClassStructure> childrenValidators = new LinkedHashSet<ModelValidatorClassStructure>();

        public Builder(RestObjectModelClass modelClass) {
            this.modelClass = (RestObjectModelClass)((Object)Requires.require((Object)((Object)modelClass)));
            this.classHeaderBuilder = ClassHeader.newClassHeaderBuilder((String)Names.getPackageName((TypeElement)modelClass.getModelTypeElement()));
        }

        public boolean isValidatorsNotFound() {
            return this.modelValidatorCreators.isEmpty() && this.stateLessValidatorMap.isEmpty() && this.childrenValidators.isEmpty();
        }

        public ClassHeader.Builder getClassHeaderBuilder() {
            return this.classHeaderBuilder;
        }

        public Set<ModelValidatorClassStructure> getChildrenValidators() {
            return this.childrenValidators;
        }

        public void add(RestModelField restModelField, String typeSimpleClassName, boolean validateIterable) {
            String instanceName = GeneratedClassNames.getModelTransformerInstanceName((String)typeSimpleClassName, ConstraintValidator.class);
            this.modelFieldValidatorsMap.computeIfAbsent(restModelField, m -> new ArrayList()).add(new ModelValidator(instanceName, this.getValidationMethodName(restModelField, validateIterable)));
        }

        public void add(RestModelField restModelField, ModelClass modelFieldType, ModelValidatorCreatorDescriptor modelValidatorCreatorDescriptor, String constructorArgs, boolean validateIterable) {
            String instanceName;
            boolean isStateless = (constructorArgs == null || constructorArgs.isEmpty()) && Names.getPackageName((String)modelValidatorCreatorDescriptor.getValidatorFullClassName()).equals(STANDARD_VALIDATOR_PACKAGE);
            String validatorClass = this.getValidatorClassName(modelValidatorCreatorDescriptor.getValidatorFullClassName());
            if (isStateless) {
                instanceName = Names.getDefaultVarName((String)Names.getSimpleName((String)validatorClass));
                this.stateLessValidatorMap.putIfAbsent(validatorClass, new ModelValidatorCreator(validatorClass, instanceName));
            } else {
                instanceName = Formats.format((String)"???", (Object[])new Object[]{restModelField.getFieldName(), Names.getSimpleName((String)modelValidatorCreatorDescriptor.getConstraintAnnotationFullName()), Names.getSimpleName((String)validatorClass)});
                if (modelValidatorCreatorDescriptor.isParametrizedConstraintValidator()) {
                    String validatedType = modelFieldType.isIterable() ? modelFieldType.asIterable().getElementModelClass().getJavaSimpleClassName() : modelFieldType.getJavaSimpleClassName();
                    this.modelValidatorCreators.add(new ModelValidatorCreator(validatorClass, instanceName, validatedType, constructorArgs));
                } else {
                    this.modelValidatorCreators.add(new ModelValidatorCreator(validatorClass, instanceName, constructorArgs));
                }
            }
            this.modelFieldValidatorsMap.computeIfAbsent(restModelField, m -> new ArrayList()).add(new ModelValidator(instanceName, this.getValidationMethodName(restModelField, validateIterable)));
        }

        private String getValidationMethodName(RestModelField restModelField, boolean validateIterable) {
            if (validateIterable) {
                if (Map.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(restModelField.getFieldClass()).toString())) {
                    return "validateMapValues";
                }
                return "validateIterable";
            }
            return "validate";
        }

        private String getValidatorClassName(String validatorClass) {
            if (validatorClass.startsWith(STANDARD_VALIDATOR_PACKAGE)) {
                this.stdValidatorClassImports.add(Names.getTypeWithoutGeneric((String)validatorClass));
                return Names.getSimpleName((String)Names.getTypeWithoutGeneric((String)validatorClass));
            }
            return validatorClass;
        }

        public ModelValidatorClassStructure build(boolean optional) {
            return new ModelValidatorClassStructure(optional, this.classHeaderBuilder, this.modelClass, Stream.concat(this.stateLessValidatorMap.values().stream(), this.modelValidatorCreators.stream()).collect(Collectors.toList()), this.modelFieldValidatorsMap.entrySet().stream().map(e -> new ModelFieldValidatorsInvoker((RestModelField)((Object)((Object)e.getKey())), (List)e.getValue())).collect(Collectors.toList()), this.stdValidatorClassImports, this.childrenValidators);
        }
    }
}

