/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model.validator;

import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorCreatorDescriptor;
import io.rxmicro.common.util.Requires;
import io.rxmicro.validation.base.ParametrizedConstraintValidator;
import io.rxmicro.validation.constraint.MaxSize;
import io.rxmicro.validation.constraint.MinSize;
import io.rxmicro.validation.constraint.Size;
import io.rxmicro.validation.constraint.UniqueItems;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class ModelConstraintAnnotation
implements ModelValidatorCreatorDescriptor {
    private static final Set<String> ITERABLE_VALIDATOR_CONSTRAINT_CLASS_NAMES = Set.of(Size.class.getName(), MinSize.class.getName(), MaxSize.class.getName(), UniqueItems.class.getName());
    private final Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues;
    private final AnnotationMirror annotationMirror;
    private final TypeElement validatorType;

    public ModelConstraintAnnotation(Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues, AnnotationMirror annotationMirror, TypeElement validatorType) {
        this.elementValues = (Map)Requires.require(elementValues);
        this.annotationMirror = (AnnotationMirror)Requires.require((Object)annotationMirror);
        this.validatorType = (TypeElement)Requires.require((Object)validatorType);
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.elementValues;
    }

    @Override
    public String getConstraintAnnotationFullName() {
        return this.annotationMirror.getAnnotationType().toString();
    }

    public boolean isIterableConstraint() {
        return ITERABLE_VALIDATOR_CONSTRAINT_CLASS_NAMES.contains(this.getConstraintAnnotationFullName());
    }

    @Override
    public String getValidatorFullClassName() {
        return this.validatorType.asType().toString();
    }

    @Override
    public boolean isParametrizedConstraintValidator() {
        return this.validatorType.getAnnotation(ParametrizedConstraintValidator.class) != null;
    }
}

