/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Elements;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class RestResponseModel {
    public static final RestResponseModel VOID = new RestResponseModel(null);
    private final MethodResult methodResult;

    public RestResponseModel(MethodResult methodResult) {
        this.methodResult = methodResult;
    }

    public Set<String> getRequiredImports() {
        return this.methodResult != null ? this.methodResult.getRequiredImports() : Set.of();
    }

    public String getHumanReadableReturnType() {
        return this.methodResult != null ? this.methodResult.getHumanReadableReturnType() : "void";
    }

    public boolean isVoidReturn() {
        return this.methodResult == null;
    }

    public boolean isReactiveVoid() {
        return this.methodResult != null && this.methodResult.isVoid();
    }

    public Optional<MethodResult> getMethodResult() {
        return Optional.ofNullable(this.methodResult);
    }

    public boolean isFuture() {
        return this.methodResult != null && this.methodResult.isFuture();
    }

    public boolean isMono() {
        return this.methodResult != null && this.methodResult.isMono();
    }

    public boolean isMaybe() {
        return this.methodResult != null && this.methodResult.isMaybe();
    }

    public boolean isSingle() {
        return this.methodResult != null && this.methodResult.isSingle();
    }

    public boolean isCompletable() {
        return this.methodResult != null && this.methodResult.isCompletable();
    }

    public Optional<TypeMirror> getReactiveType() {
        return Optional.ofNullable(this.methodResult).map(MethodResult::getReactiveType);
    }

    public Optional<TypeElement> getResultType() {
        return Optional.ofNullable(this.methodResult).filter(r -> !r.isVoid()).flatMap(r -> Elements.asTypeElement((TypeMirror)r.getResultType()));
    }

    public boolean isOptional() {
        return this.methodResult != null && this.methodResult.isOneItem() && this.methodResult.isOptional();
    }
}

