/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.Optional;
import javax.lang.model.element.TypeElement;

public final class RestRequestModel {
    public static final RestRequestModel VOID = new RestRequestModel();
    private final TypeElement requestType;
    private final String variableName;

    private RestRequestModel() {
        this.requestType = null;
        this.variableName = null;
    }

    public RestRequestModel(TypeElement requestType, String variableName) {
        this.requestType = (TypeElement)Requires.require((Object)requestType);
        this.variableName = (String)Requires.require((Object)variableName);
    }

    public boolean isVirtual() {
        return Elements.isVirtualTypeElement((TypeElement)this.requestType);
    }

    public boolean requestModelNotExists() {
        return this.requestType == null;
    }

    public boolean requestModelExists() {
        return this.requestType != null;
    }

    public Optional<TypeElement> getRequestType() {
        return Optional.ofNullable(this.requestType);
    }

    public TypeElement getRequiredRequestType() {
        return this.getRequestType().orElseThrow(Errors.createInternalErrorSupplier((String)"Expected request model type", (Object[])new Object[0]));
    }

    public String getRequiredVariableName() {
        return (String)Requires.require((Object)this.variableName);
    }

    public String toString() {
        return VOID.equals(this) ? "" : Formats.format((String)"? ?", (Object[])new Object[]{this.getRequiredRequestType().asType(), this.getRequiredVariableName()});
    }
}

