/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.PrimitiveType;
import io.rxmicro.common.util.Requires;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public enum RestPrimitiveType implements PrimitiveType
{
    BOOLEAN("toBoolean", "boolean"),
    BYTE("toByte", "number"),
    SHORT("toShort", "number"),
    INT("toInteger", "number"),
    LONG("toLong", "number"),
    CHAR("toCharacter", "string"),
    FLOAT("toFloat", "number"),
    DOUBLE("toDouble", "number"),
    DECIMAL("toBigDecimal", "number"),
    BIGINT("toBigInteger", "number"),
    STRING("toString", "string"),
    INSTANT("toInstant", "string");

    private static final Map<String, RestPrimitiveType> MAPPING;
    private final String convertMethod;
    private final String jsonType;

    private RestPrimitiveType(String convertMethod, String jsonType) {
        this.convertMethod = (String)Requires.require((Object)convertMethod);
        this.jsonType = jsonType;
    }

    public static RestPrimitiveType valueOf(TypeMirror typeMirror) {
        return Optional.ofNullable(MAPPING.get(typeMirror.toString())).orElseThrow(() -> new InternalErrorException("Json primitive allowed only: ?", new Object[]{typeMirror}));
    }

    public String getConvertMethod() {
        return this.convertMethod;
    }

    public String toJsonType() {
        return this.jsonType;
    }

    static {
        MAPPING = Map.ofEntries(Map.entry(Instant.class.getName(), INSTANT), Map.entry(String.class.getName(), STRING), Map.entry(BigDecimal.class.getName(), DECIMAL), Map.entry(BigInteger.class.getName(), BIGINT), Map.entry(Boolean.class.getName(), BOOLEAN), Map.entry(Byte.class.getName(), BYTE), Map.entry(Short.class.getName(), SHORT), Map.entry(Integer.class.getName(), INT), Map.entry(Long.class.getName(), LONG), Map.entry(Character.class.getName(), CHAR), Map.entry(Float.class.getName(), FLOAT), Map.entry(Double.class.getName(), DOUBLE));
    }
}

