/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.exchange.json.detail.ModelFromJsonConverter;
import io.rxmicro.exchange.json.detail.ModelToJsonConverter;
import io.rxmicro.validation.ConstraintValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class RestObjectModelClass
extends ObjectModelClass<RestModelField> {
    protected final Map<RestModelField, ModelClass> pathVariables;
    protected final Map<RestModelField, ModelClass> headers;
    protected final Map<RestModelField, ModelClass> internals;
    private final Map<RestModelField, ModelClass> allFieldsInDeclaredOrder;

    protected RestObjectModelClass(TypeMirror modelTypeMirror, TypeElement modelTypeElement, Map<RestModelField, ModelClass> fields, ObjectModelClass<RestModelField> parent, boolean modelClassReturnedByRestMethod) {
        super(modelTypeMirror, modelTypeElement, (Map)fields.entrySet().stream().filter(e -> ((RestModelField)((Object)((Object)e.getKey()))).isHttpParameter()).collect(ExCollectors.toUnmodifiableOrderedMap(Map.Entry::getKey, Map.Entry::getValue)), parent, modelClassReturnedByRestMethod);
        this.allFieldsInDeclaredOrder = fields;
        this.pathVariables = (Map)fields.entrySet().stream().filter(e -> ((RestModelField)((Object)((Object)e.getKey()))).isHttpPathVariable()).collect(ExCollectors.toUnmodifiableOrderedMap(Map.Entry::getKey, Map.Entry::getValue));
        this.headers = (Map)fields.entrySet().stream().filter(e -> ((RestModelField)((Object)((Object)e.getKey()))).isHttpHeader()).collect(ExCollectors.toUnmodifiableOrderedMap(Map.Entry::getKey, Map.Entry::getValue));
        this.internals = (Map)fields.entrySet().stream().filter(e -> ((RestModelField)((Object)((Object)e.getKey()))).isInternalType()).collect(ExCollectors.toUnmodifiableOrderedMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Optional<RestObjectModelClass> getParent() {
        return super.getParent().map(o -> (RestObjectModelClass)((Object)o));
    }

    public boolean isReadReflectionRequired() {
        Predicate<RestModelField> predicate = m -> m.getModelReadAccessorType() == ModelAccessorType.REFLECTION;
        return super.isReadReflectionRequired() || this.pathVariables.keySet().stream().anyMatch(predicate) || this.headers.keySet().stream().anyMatch(predicate) || this.internals.keySet().stream().anyMatch(predicate);
    }

    public boolean isWriteReflectionRequired() {
        Predicate<RestModelField> predicate = m -> m.getModelWriteAccessorType() == ModelAccessorType.REFLECTION;
        return super.isWriteReflectionRequired() || this.pathVariables.keySet().stream().anyMatch(predicate) || this.headers.keySet().stream().anyMatch(predicate) || this.internals.keySet().stream().anyMatch(predicate);
    }

    public List<TypeMirror> getModelFieldTypes() {
        return ExCollections.join((List[])new List[]{super.getModelFieldTypes(), this.pathVariables.keySet().stream().map(ModelField::getFieldClass).collect(Collectors.toList()), this.headers.keySet().stream().map(ModelField::getFieldClass).collect(Collectors.toList()), this.internals.keySet().stream().map(ModelField::getFieldClass).collect(Collectors.toList())});
    }

    public boolean isHeaderReadReflectionRequired() {
        return this.headers.keySet().stream().anyMatch(m -> m.getModelReadAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isInternalsReadReflectionRequired() {
        return this.internals.keySet().stream().anyMatch(m -> m.getModelReadAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isPathVariablesReadReflectionRequired() {
        return this.pathVariables.keySet().stream().anyMatch(m -> m.getModelReadAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isParamsWriteReflectionRequired() {
        return this.getParamEntries().stream().anyMatch(m -> ((RestModelField)((Object)((Object)m.getKey()))).getModelWriteAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isParamsReadReflectionRequired() {
        return this.getParamEntries().stream().anyMatch(m -> ((RestModelField)((Object)((Object)m.getKey()))).getModelReadAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isInternalsPresent() {
        return !this.internals.isEmpty();
    }

    public Collection<RestModelField> getInternals() {
        return this.internals.keySet();
    }

    public boolean isHeadersPresent() {
        return !this.getHeaderEntries().isEmpty();
    }

    public boolean isPathVariablesPresent() {
        return !this.pathVariables.isEmpty();
    }

    public boolean isHeadersOrPathVariablesOrInternalsPresent() {
        return this.isHeadersPresent() || this.isPathVariablesPresent() || this.isInternalsPresent();
    }

    public boolean isHeadersOrPathVariablesOrInternalsPresentAtThisOrAnyParent() {
        return this.isHeadersOrPathVariablesOrInternalsPresent() || this.getParent().map(RestObjectModelClass::isHeadersOrPathVariablesOrInternalsPresent).orElse(false) != false;
    }

    public Set<Map.Entry<RestModelField, ModelClass>> getHeaderEntries() {
        return this.headers.entrySet();
    }

    public Set<Map.Entry<RestModelField, ModelClass>> getParamEntries() {
        return super.getParamEntries();
    }

    public Set<Map.Entry<RestModelField, ModelClass>> getPathVariableEntries() {
        return this.pathVariables.entrySet();
    }

    public Map<String, RestModelField> getPathVariableMap() {
        return this.pathVariables.keySet().stream().collect(Collectors.toMap(ModelField::getModelName, Function.identity()));
    }

    public String getFromJsonConverterInstanceName() {
        return GeneratedClassNames.getModelTransformerInstanceName((String)this.getJavaSimpleClassName(), ModelFromJsonConverter.class);
    }

    public String getModelFromJsonConverterImplSimpleClassName() {
        return GeneratedClassNames.getModelTransformerSimpleClassName((TypeElement)this.getModelTypeElement(), ModelFromJsonConverter.class);
    }

    public String getModelFromJsonConverterImplFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.getModelTypeElement(), ModelFromJsonConverter.class);
    }

    public String getToJsonConverterInstanceName() {
        return GeneratedClassNames.getModelTransformerInstanceName((String)this.getJavaSimpleClassName(), ModelToJsonConverter.class);
    }

    public String getModelToJsonConverterImplSimpleClassName() {
        return GeneratedClassNames.getModelTransformerSimpleClassName((TypeElement)this.getModelTypeElement(), ModelToJsonConverter.class);
    }

    public String getModelToJsonConverterImplFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.getModelTypeElement(), ModelToJsonConverter.class);
    }

    public String getModelValidatorImplSimpleClassName() {
        return GeneratedClassNames.getModelTransformerSimpleClassName((TypeElement)this.getModelTypeElement(), ConstraintValidator.class);
    }

    public String getModelValidatorInstanceName() {
        return GeneratedClassNames.getModelTransformerInstanceName((String)this.getJavaSimpleClassName(), ConstraintValidator.class);
    }

    public Collection<Map.Entry<RestModelField, ModelClass>> getAllOrderedDeclaredFields() {
        return this.allFieldsInDeclaredOrder.entrySet();
    }

    public final Stream<Map.Entry<RestModelField, ModelClass>> getAllDeclaredHeadersStream(boolean excludeRequestIdHeader) {
        return Stream.concat(this.getAllParents().stream().flatMap(p -> ((RestObjectModelClass)((Object)p)).getHeaderEntries().stream()), this.getHeaderEntries().stream()).filter(e -> !excludeRequestIdHeader || !"Request-Id".equals(((RestModelField)((Object)((Object)e.getKey()))).getModelName()));
    }

    public final Stream<Map.Entry<RestModelField, ModelClass>> getAllDeclaredPathVariablesStream() {
        return Stream.concat(this.getAllParents().stream().flatMap(p -> ((RestObjectModelClass)((Object)p)).getPathVariableEntries().stream()), this.getPathVariableEntries().stream());
    }
}

