/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.rest.model.InternalType;
import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.constraint.Nullable;
import java.lang.annotation.Annotation;

public final class RestModelField
extends ModelField {
    private final HttpModelType httpModelType;
    private final InternalType internalType;
    private final boolean repeat;

    public RestModelField(AnnotatedModelElement annotatedModelElement, HttpModelType httpModelType, String modelName, boolean repeat) {
        super(annotatedModelElement, modelName);
        this.httpModelType = (HttpModelType)Requires.require((Object)httpModelType);
        this.internalType = null;
        this.repeat = repeat;
    }

    public RestModelField(AnnotatedModelElement annotatedModelElement, HttpModelType httpModelType, String modelName) {
        this(annotatedModelElement, httpModelType, modelName, false);
    }

    public RestModelField(AnnotatedModelElement annotatedModelElement, InternalType internalType) {
        super(annotatedModelElement, internalType.name());
        this.httpModelType = HttpModelType.INTERNAL;
        this.internalType = internalType;
        this.repeat = false;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == Nullable.class) {
            if (this.isHttpPathVariable()) {
                return (T)Annotations.defaultAnnotationInstance(Nullable.class);
            }
            if (this.isHttpHeader() && "Request-Id".equalsIgnoreCase(this.getModelName())) {
                return (T)Annotations.defaultAnnotationInstance(Nullable.class);
            }
        }
        return (T)super.getAnnotation(annotationClass);
    }

    public HttpModelType getHttpModelType() {
        return this.httpModelType;
    }

    public boolean isHttpHeader() {
        return this.httpModelType == HttpModelType.HEADER;
    }

    public boolean isHttpParameter() {
        return this.httpModelType == HttpModelType.PARAMETER;
    }

    public boolean isHttpPathVariable() {
        return this.httpModelType == HttpModelType.PATH;
    }

    public boolean isInternalType() {
        return this.httpModelType == HttpModelType.INTERNAL;
    }

    public boolean isRemoteAddress() {
        return this.isInternalType() && this.internalType == InternalType.REMOTE_ADDRESS;
    }

    public boolean isRemoteAddressStringType() {
        return String.class.getName().equals(this.getFieldClass().toString());
    }

    public boolean isRequestBody() {
        return this.isInternalType() && this.internalType == InternalType.REQUEST_BODY;
    }

    public boolean isHttpRequest() {
        return this.isInternalType() && this.internalType == InternalType.HTTP_REQUEST;
    }

    public boolean isHttpHeaders() {
        return this.isInternalType() && this.internalType == InternalType.HTTP_HEADERS;
    }

    public boolean isHttpVersion() {
        return this.isInternalType() && this.internalType == InternalType.HTTP_VERSION;
    }

    public boolean isResponseStatus() {
        return this.isInternalType() && this.internalType == InternalType.RESPONSE_STATUS;
    }

    public boolean isResponseBody() {
        return this.isInternalType() && this.internalType == InternalType.RESPONSE_BODY;
    }

    public boolean isRequestUrl() {
        return this.isInternalType() && this.internalType == InternalType.REQUEST_URL;
    }

    public boolean isRequestMethod() {
        return this.isInternalType() && this.internalType == InternalType.REQUEST_METHOD;
    }
}

