/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.common.util.Requires;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.rest.Version;
import java.util.ArrayList;
import java.util.List;

public final class ParentUrl {
    private final List<String> beforeVersionUrlPaths;
    private final Version version;
    private final List<String> afterVersionUrlPaths;

    private ParentUrl(List<String> beforeVersionUrlPaths, Version version, List<String> afterVersionUrlPaths) {
        this.beforeVersionUrlPaths = beforeVersionUrlPaths;
        this.afterVersionUrlPaths = afterVersionUrlPaths;
        this.version = version;
    }

    public String getFullUrlPath(String childUrl) {
        ArrayList<String> urlParts = new ArrayList<String>(this.beforeVersionUrlPaths);
        if (this.isUrlPathVersionStrategy()) {
            urlParts.add(this.getVersionValue());
        }
        urlParts.addAll(this.afterVersionUrlPaths);
        urlParts.add(childUrl);
        return UrlPaths.normalizeUrlPath((String)String.join((CharSequence)"/", urlParts));
    }

    public boolean isVersionPresent() {
        return this.version != null;
    }

    public String getVersionValue() {
        return this.version.value();
    }

    public boolean isUrlPathVersionStrategy() {
        return this.isVersionPresent() && this.version.strategy() == Version.Strategy.URL_PATH;
    }

    public boolean isHeaderVersionStrategy() {
        return this.isVersionPresent() && this.version.strategy() == Version.Strategy.HEADER;
    }

    public String getVersionHeaderName() {
        return Version.Strategy.HEADER.getParamName();
    }

    public String toString() {
        return this.getFullUrlPath("");
    }

    public static final class Builder {
        private final List<String> beforeVersionUrlPaths = new ArrayList<String>();
        private final List<String> afterVersionUrlPaths = new ArrayList<String>();
        private Version version;

        public void addBeforeVersionUrlPath(String beforeVersionUrlPath) {
            this.beforeVersionUrlPaths.add(beforeVersionUrlPath);
        }

        public void setVersion(Version version) {
            this.version = (Version)Requires.require((Object)version);
        }

        public void addAfterVersionUrlPath(String afterVersionUrlPath) {
            this.afterVersionUrlPaths.add(afterVersionUrlPath);
        }

        public ParentUrl build() {
            return new ParentUrl(this.beforeVersionUrlPaths, this.version, this.afterVersionUrlPaths);
        }
    }
}

