/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.converter.ReaderType;
import io.rxmicro.common.util.Requires;
import java.util.List;

public final class MappedRestObjectModelClass {
    private final RestObjectModelClass modelClass;
    private final List<HttpMethodMapping> httpMethodMappings;

    public MappedRestObjectModelClass(RestObjectModelClass modelClass, List<HttpMethodMapping> httpMethodMappings) {
        this.modelClass = (RestObjectModelClass)((Object)Requires.require((Object)((Object)modelClass)));
        this.httpMethodMappings = (List)Requires.require(httpMethodMappings);
    }

    public MappedRestObjectModelClass cloneUsingNewModelClass(RestObjectModelClass modelClass) {
        return new MappedRestObjectModelClass(modelClass, this.httpMethodMappings);
    }

    public RestObjectModelClass getModelClass() {
        return this.modelClass;
    }

    public List<HttpMethodMapping> getHttpMethodMappings() {
        return this.httpMethodMappings;
    }

    public ReaderType getReaderType() {
        boolean query = false;
        boolean body = false;
        for (HttpMethodMapping descriptor : this.httpMethodMappings) {
            if (descriptor.isHttpBody()) {
                body = true;
                continue;
            }
            query = true;
        }
        if (query && !body) {
            return ReaderType.QUERY_STRING;
        }
        if (body && !query) {
            return ReaderType.HTTP_BODY;
        }
        return ReaderType.QUERY_OR_HTTP_BODY;
    }

    public String toString() {
        return "MappedRestObjectModelClass{modelClass=" + this.modelClass + ", httpMethodMappings=" + this.httpMethodMappings + "}";
    }
}

