/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.model.UrlSegments;
import java.lang.annotation.Annotation;

public final class HttpMethodMapping {
    private final String method;
    private final String uri;
    private final UrlSegments urlSegments;
    private final boolean httpBody;
    private final String versionHeaderValue;

    private HttpMethodMapping(String method, String uri, UrlSegments urlSegments, boolean httpBody, String versionHeaderValue) {
        this.method = (String)Requires.require((Object)method);
        this.uri = uri;
        this.urlSegments = urlSegments;
        this.httpBody = httpBody;
        this.versionHeaderValue = versionHeaderValue;
    }

    public String getMethod() {
        return this.method;
    }

    public String getExactOrTemplateUri() {
        if (this.isUrlSegmentsPresent()) {
            return this.urlSegments.getOriginalUrl();
        }
        return this.uri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isHttpBody() {
        return this.httpBody;
    }

    public boolean isUrlSegmentsPresent() {
        return this.urlSegments != null;
    }

    public UrlSegments getUrlSegments() {
        return (UrlSegments)Requires.require((Object)this.urlSegments);
    }

    public boolean isVersionHeaderValuePresent() {
        return this.versionHeaderValue != null;
    }

    public String getVersionHeaderValue() {
        return (String)Requires.require((Object)this.versionHeaderValue);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + (this.httpBody ? 1 : 0);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HttpMethodMapping that = (HttpMethodMapping)other;
        if (this.httpBody != that.httpBody) {
            return false;
        }
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.uri.equals(that.uri);
    }

    public String toString() {
        return "HttpMethodMapping{method='" + this.method + "', uri='" + this.uri + "', urlSegments=" + this.urlSegments + ", httpBody=" + this.httpBody + "}";
    }

    public static final class Builder {
        private String method;
        private String uri;
        private UrlSegments urlSegments;
        private boolean httpBody;
        private String versionHeaderValue;

        public Builder setMethod(Class<? extends Annotation> method) {
            this.method = ((Class)Requires.require(method)).getSimpleName();
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = (String)Requires.require((Object)uri);
            return this;
        }

        public Builder setUrlSegments(UrlSegments urlSegments) {
            this.urlSegments = (UrlSegments)Requires.require((Object)urlSegments);
            return this;
        }

        public Builder setHttpBody(boolean httpBody) {
            this.httpBody = httpBody;
            return this;
        }

        public Builder setVersionHeaderValue(String versionHeaderValue) {
            this.versionHeaderValue = (String)Requires.require((Object)versionHeaderValue);
            return this;
        }

        public HttpMethodMapping build() {
            return new HttpMethodMapping(this.method, this.uri, this.urlSegments, this.httpBody, this.versionHeaderValue);
        }
    }
}

