/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.model.ExchangeFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public abstract class AbstractModelJsonConverterClassStructure
extends ClassStructure {
    protected final RestObjectModelClass modelClass;
    private final Set<ObjectModelClass<RestModelField>> allChildrenObjectModelClasses;
    private final ExchangeFormat exchangeFormat;

    protected AbstractModelJsonConverterClassStructure(RestObjectModelClass modelClass, ExchangeFormat exchangeFormat) {
        this.modelClass = (RestObjectModelClass)((Object)Requires.require((Object)((Object)modelClass)));
        this.exchangeFormat = (ExchangeFormat)Requires.require((Object)exchangeFormat);
        this.allChildrenObjectModelClasses = modelClass.getAllChildrenObjectModelClasses();
    }

    public final RestObjectModelClass getModelClass() {
        return this.modelClass;
    }

    public final String getModelFullClassName() {
        return this.modelClass.getJavaFullClassName();
    }

    public final String getTargetFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.modelClass.getModelTypeElement(), this.getBaseTransformerClass());
    }

    public final String getTemplateName() {
        if (this.exchangeFormat == ExchangeFormat.JSON_EXCHANGE_FORMAT) {
            return "rest/$$Rest" + this.getBaseTransformerClass().getSimpleName() + "Template.javaftl";
        }
        throw new InternalErrorException("Not impl yet", new Object[0]);
    }

    public final Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JAVA_MODEL_CLASS", (Object)this.modelClass);
        map.put("JAVA_MODEL_CONVERTER_CHILDREN", this.allChildrenObjectModelClasses);
        this.customize(map);
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder builder = ClassHeader.newClassHeaderBuilder((String)Names.getPackageName((TypeElement)this.modelClass.getModelTypeElement())).addImports((String[])this.allChildrenObjectModelClasses.stream().map(v -> GeneratedClassNames.getModelTransformerFullClassName((TypeElement)v.getModelTypeElement(), this.getBaseTransformerClass())).toArray(String[]::new)).addImports(new Class[]{Map.class}).addImports(this.modelClass.getModelFieldTypes());
        this.addRequiredImports(builder);
        return builder.build();
    }

    protected abstract void addRequiredImports(ClassHeader.Builder var1);

    protected abstract Class<?> getBaseTransformerClass();

    protected void customize(Map<String, Object> map) {
    }
}

