/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl.builder;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.rest.component.RestModelFieldBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.rest.PathVariable;
import io.rxmicro.rest.model.HttpModelType;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class PathVariableRestModelFieldBuilder
extends BaseProcessorComponent
implements RestModelFieldBuilder<PathVariable> {
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    @Override
    public RestModelField build(ModelFieldType modelFieldType, TypeElement typeElement, AnnotatedModelElement annotated, PathVariable pathVariable, Set<String> modelNames, int nestedLevel) {
        String modelName;
        VariableElement field = annotated.getField();
        if (nestedLevel > 1) {
            this.error(annotated.getElementAnnotatedBy(PathVariable.class).orElse(field), "Annotation @? not allowed here. Path variable can be defined in root class only", new Object[]{PathVariable.class.getSimpleName()});
        }
        String string = modelName = !pathVariable.value().isEmpty() ? pathVariable.value() : field.getSimpleName().toString();
        if (!modelNames.add(modelName)) {
            this.error(annotated.getElementAnnotatedBy(PathVariable.class).orElse(field), "Detected duplicate of path variable name: ?", new Object[]{modelName});
        }
        if (!this.supportedTypesProvider.isModelPrimitive(field.asType())) {
            this.error(annotated.getElementAnnotatedBy(PathVariable.class).orElse(field), "Invalid path variable type. Allowed types are: ?", new Object[]{this.supportedTypesProvider.getPrimitives()});
        }
        return new RestModelField(annotated, HttpModelType.PATH, modelName);
    }
}

