/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl.builder;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.rest.component.RestModelFieldBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.http.local.HttpValidators;
import io.rxmicro.rest.Parameter;
import io.rxmicro.rest.ParameterMappingStrategy;
import io.rxmicro.rest.RepeatQueryParameter;
import io.rxmicro.rest.model.HttpModelType;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class ParameterRestModelFieldBuilder
extends BaseProcessorComponent
implements RestModelFieldBuilder<Parameter> {
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    @Override
    public RestModelField build(ModelFieldType modelFieldType, TypeElement typeElement, AnnotatedModelElement annotated, Parameter parameter, Set<String> modelNames, int nestedLevel) {
        ParameterMappingStrategy strategy;
        VariableElement field = annotated.getField();
        String customParameterName = parameter != null ? parameter.value() : "";
        String modelName = annotated.getModelName(customParameterName, (Annotation)(strategy = typeElement.getAnnotation(ParameterMappingStrategy.class)), () -> strategy.value());
        if (!modelNames.add(modelName)) {
            this.error(annotated.getElementAnnotatedBy(Parameter.class).orElse(field), "Detected duplicate of HTTP parameter name: ?", new Object[]{modelName});
        }
        try {
            HttpValidators.validateParameterName((String)modelName);
        }
        catch (IllegalArgumentException ex) {
            this.error(annotated.getElementAnnotatedBy(Parameter.class).orElse(field), ex.getMessage(), new Object[0]);
        }
        boolean repeat = annotated.isAnnotationPresent(RepeatQueryParameter.class);
        if (repeat) {
            this.validateRepeatQueryParameter(modelFieldType, annotated);
        }
        return new RestModelField(annotated, HttpModelType.PARAMETER, modelName, repeat);
    }

    private void validateRepeatQueryParameter(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        if (modelFieldType == ModelFieldType.REST_CLIENT_RESPONSE || modelFieldType == ModelFieldType.REST_SERVER_RESPONSE || modelFieldType == ModelFieldType.REST_SERVER_REQUEST) {
            throw new InterruptProcessingException((Element)annotated.getElementAnnotatedBy(RepeatQueryParameter.class).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "'@?' annotation can be applied for client HTTP request model only! Remove the redundant annotation!", new Object[]{RepeatQueryParameter.class});
        }
        if (!this.supportedTypesProvider.isModelPrimitiveList(annotated.getField().asType())) {
            throw new InterruptProcessingException((Element)annotated.getElementAnnotatedBy(RepeatQueryParameter.class).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "'@?' annotation can be applied for array type only! Remove the redundant annotation!", new Object[]{RepeatQueryParameter.class});
        }
    }
}

