/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl.builder;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.rest.component.RestModelFieldBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.http.local.HttpValidators;
import io.rxmicro.rest.Header;
import io.rxmicro.rest.HeaderMappingStrategy;
import io.rxmicro.rest.RepeatHeader;
import io.rxmicro.rest.model.HttpModelType;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class HeaderRestModelFieldBuilder
extends BaseProcessorComponent
implements RestModelFieldBuilder<Header> {
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    @Override
    public RestModelField build(ModelFieldType modelFieldType, TypeElement typeElement, AnnotatedModelElement annotated, Header header, Set<String> modelNames, int nestedLevel) {
        TypeMirror fieldType;
        VariableElement field = annotated.getField();
        if (nestedLevel > 1) {
            this.error(annotated.getElementAnnotatedBy(Header.class).orElse(field), "Annotation @? not allowed here. Header can be defined in root class only", new Object[]{Header.class.getSimpleName()});
        }
        if (!this.supportedTypesProvider.isModelPrimitive(fieldType = field.asType()) && !this.supportedTypesProvider.isModelPrimitiveList(fieldType)) {
            this.error(annotated.getElementAnnotatedBy(Header.class).orElse(field), "Invalid header type. Allowed types are: ?", new Object[]{this.supportedTypesProvider.getPrimitives()});
        }
        if (Map.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(annotated.getField().asType()).toString())) {
            this.error(annotated.getElementAnnotatedBy(Header.class).orElse(field), "Invalid header type: java.util.Map<String, ?> is not valid type for HTTP header!", new Object[0]);
        }
        HeaderMappingStrategy strategy = typeElement.getAnnotation(HeaderMappingStrategy.class);
        String modelName = annotated.getModelName(header.value(), (Annotation)strategy, () -> strategy.value());
        if (!modelNames.add(modelName)) {
            this.error(annotated.getElementAnnotatedBy(Header.class).orElse(field), "Detected duplicate of HTTP header name: ?. For multi value header use List<?> type and '@?' annotation", new Object[]{modelName, Names.getSimpleName((TypeMirror)field.asType()), RepeatHeader.class});
        }
        boolean repeat = annotated.isAnnotationPresent(RepeatHeader.class);
        this.validateHeader(modelFieldType, annotated, modelName, repeat);
        return new RestModelField(annotated, HttpModelType.HEADER, modelName, repeat);
    }

    private void validateHeader(ModelFieldType modelFieldType, AnnotatedModelElement annotated, String modelName, boolean repeat) {
        try {
            HttpValidators.validateHeaderName((String)modelName);
        }
        catch (IllegalArgumentException ex) {
            this.error(annotated.getElementAnnotatedBy(Header.class).orElse(annotated.getField()), ex.getMessage(), new Object[0]);
        }
        if (repeat) {
            this.validateRepeatHeader(modelFieldType, annotated);
        }
    }

    private void validateRepeatHeader(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        if (modelFieldType == ModelFieldType.REST_SERVER_REQUEST) {
            throw new InterruptProcessingException((Element)annotated.getElementAnnotatedBy(RepeatHeader.class).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "'@?' annotation can be applied for server HTTP response model only! Remove the redundant annotation!", new Object[]{RepeatHeader.class});
        }
        if (modelFieldType == ModelFieldType.REST_CLIENT_RESPONSE) {
            throw new InterruptProcessingException((Element)annotated.getElementAnnotatedBy(RepeatHeader.class).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "'@?' annotation can be applied for client HTTP request model only! Remove the redundant annotation!", new Object[]{RepeatHeader.class});
        }
        if (!this.supportedTypesProvider.isModelPrimitiveList(annotated.getField().asType())) {
            throw new InterruptProcessingException((Element)annotated.getElementAnnotatedBy(RepeatHeader.class).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "'@?' annotation can be applied for array type only! Remove the redundant annotation!", new Object[]{RepeatHeader.class});
        }
    }
}

