/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.MethodResultBuilder;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.ModelTypeElements;
import io.rxmicro.annotation.processor.rest.component.RestResponseModelBuilder;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestResponseModelBuilderImpl
implements RestResponseModelBuilder {
    @Inject
    private MethodResultBuilder methodResultBuilder;
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    @Override
    public RestResponseModel build(ModuleElement restControllerModule, ExecutableElement method, boolean requireDefConstructor) {
        TypeMirror returnType = method.getReturnType();
        if (returnType.getKind() == TypeKind.VOID) {
            return RestResponseModel.VOID;
        }
        MethodResult methodResult = this.methodResultBuilder.build(method, this.supportedTypesProvider);
        if (methodResult.isPrimitive()) {
            throw new InterruptProcessingException((Element)method, "Response couldn't be a primitive! Use void or model class instead!", new Object[0]);
        }
        if (methodResult.isVoid()) {
            return new RestResponseModel(methodResult);
        }
        TypeMirror resultType = methodResult.getResultType();
        ModelTypeElements.asValidatedModelTypeElement((ModuleElement)restControllerModule, (Element)method, (TypeMirror)resultType, (String)"Invalid business method result", (ModelFieldBuilderOptions)ModelFieldBuilderOptions.DEFAULT_OPTIONS);
        return new RestResponseModel(methodResult);
    }
}

