/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeElement;
import io.rxmicro.annotation.processor.common.util.ModelTypeElements;
import io.rxmicro.annotation.processor.rest.component.RestRequestModelBuilder;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestRequestModelBuilderImpl
implements RestRequestModelBuilder {
    private static final String VIRTUAL_REQUEST_SIMPLE_CLASS_NAME_TEMPLATE = "${owner}Request${index}";
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    @Override
    public RestRequestModel build(ModuleElement restControllerModule, ExecutableElement method, boolean isRequestObjectBuiltByFramework) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.isEmpty()) {
            return RestRequestModel.VOID;
        }
        VariableElement parameter = parameters.get(0);
        TypeMirror type = parameter.asType();
        if (parameters.size() == 1 && !this.supportedTypesProvider.getNotEntityMethodParameters().contains(type) && !type.getKind().isPrimitive()) {
            ModelFieldBuilderOptions options = new ModelFieldBuilderOptions().setRequireDefConstructor(isRequestObjectBuiltByFramework);
            return new RestRequestModel(ModelTypeElements.asValidatedModelTypeElement((ModuleElement)restControllerModule, (Element)method, (TypeMirror)type, (String)"Invalid business method parameter", (ModelFieldBuilderOptions)options), parameter.getSimpleName().toString());
        }
        if (isRequestObjectBuiltByFramework) {
            for (VariableElement variableElement : parameters) {
                if (!variableElement.asType().getKind().isPrimitive()) continue;
                throw new InterruptProcessingException((Element)method, "Primitive parameter type is not allowed. Use Java boxed type instead of '?' type!", new Object[]{variableElement.asType()});
            }
        }
        return new RestRequestModel((TypeElement)new VirtualTypeElement(VIRTUAL_REQUEST_SIMPLE_CLASS_NAME_TEMPLATE, method), "virtualRequest");
    }
}

