/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.rest.component.AnnotationValueConverter;
import io.rxmicro.annotation.processor.rest.component.AnnotationValueValidator;
import io.rxmicro.annotation.processor.rest.component.ConstraintAnnotationExtractor;
import io.rxmicro.annotation.processor.rest.component.RestModelValidatorBuilder;
import io.rxmicro.annotation.processor.rest.component.impl.RestModelRequiredValidatorBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.validator.ModelConstraintAnnotation;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorClassStructure;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorCreatorDescriptor;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MinNumber;
import io.rxmicro.validation.constraint.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class RestModelValidatorBuilderImpl
extends BaseProcessorComponent
implements RestModelValidatorBuilder {
    @Inject
    private ConstraintAnnotationExtractor constraintAnnotationExtractor;
    @Inject
    private AnnotationValueValidator annotationValueValidator;
    @Inject
    private AnnotationValueConverter annotationValueConverter;
    @Inject
    private RestModelRequiredValidatorBuilder restModelRequiredValidatorBuilder;

    @Override
    public Set<ModelValidatorClassStructure> build(List<RestObjectModelClass> objectModelClasses) {
        HashSet<ModelValidatorClassStructure> result = new HashSet<ModelValidatorClassStructure>();
        for (RestObjectModelClass objectModelClass : objectModelClasses) {
            boolean isValidatorGenerated = this.extractValidators(result, objectModelClass, new HashSet<ModelValidatorClassStructure>(), false);
            int sizeBefore = result.size();
            for (ObjectModelClass p : objectModelClass.getAllParents()) {
                RestObjectModelClass parent = (RestObjectModelClass)p;
                if (!parent.isModelClassReturnedByRestMethod() && !parent.isHeadersOrPathVariablesOrInternalsPresent() && !parent.isParamEntriesPresent()) continue;
                this.extractValidators(result, parent, new HashSet<ModelValidatorClassStructure>(), false);
            }
            if (isValidatorGenerated || sizeBefore >= result.size()) continue;
            result.add(new ModelValidatorClassStructure.Builder(objectModelClass).build(false));
        }
        return result;
    }

    private boolean extractValidators(Set<ModelValidatorClassStructure> result, RestObjectModelClass objectModelClass, Set<ModelValidatorClassStructure> childrenValidators, boolean optional) {
        ModelValidatorClassStructure.Builder builder = new ModelValidatorClassStructure.Builder(objectModelClass);
        this.extractPrimitiveValidators(objectModelClass, builder);
        this.extractObjectChildValidators(result, objectModelClass, builder);
        this.extractObjectIterableChildValidators(result, objectModelClass, builder);
        if (builder.isValidatorsNotFound()) {
            return false;
        }
        ModelValidatorClassStructure classStructure = builder.build(optional);
        result.add(classStructure);
        childrenValidators.add(classStructure);
        return true;
    }

    private void extractPrimitiveValidators(RestObjectModelClass objectModelClass, ModelValidatorClassStructure.Builder builder) {
        Stream.of(objectModelClass.getPathVariableEntries().stream(), objectModelClass.getHeaderEntries().stream(), objectModelClass.getParamEntries().stream()).flatMap(Function.identity()).forEach(e -> this.extractFieldValidators(builder, (RestModelField)((Object)((Object)e.getKey())), (ModelClass)e.getValue()));
    }

    private void extractObjectChildValidators(Set<ModelValidatorClassStructure> result, RestObjectModelClass objectModelClass, ModelValidatorClassStructure.Builder builder) {
        objectModelClass.getParamEntries().stream().filter(e -> ((ModelClass)e.getValue()).isObject()).forEach(e -> this.extractValidators(result, (RestObjectModelClass)((ModelClass)e.getValue()).asObject(), builder.getChildrenValidators(), ((RestModelField)((Object)((Object)e.getKey()))).hasAnnotation(Nullable.class)));
    }

    private void extractObjectIterableChildValidators(Set<ModelValidatorClassStructure> result, RestObjectModelClass objectModelClass, ModelValidatorClassStructure.Builder builder) {
        objectModelClass.getParamEntries().stream().filter(e -> ((ModelClass)e.getValue()).isIterable() && ((ModelClass)e.getValue()).asIterable().isObjectIterable()).forEach(e -> this.extractValidators(result, (RestObjectModelClass)((ModelClass)e.getValue()).asIterable().getElementModelClass(), builder.getChildrenValidators(), ((RestModelField)((Object)((Object)e.getKey()))).hasAnnotation(Nullable.class)));
    }

    private void extractFieldValidators(ModelValidatorClassStructure.Builder builder, RestModelField restModelField, ModelClass modelFieldType) {
        this.restModelRequiredValidatorBuilder.addRequiredValidator(builder, restModelField, modelFieldType);
        this.constraintAnnotationExtractor.extract(restModelField, modelFieldType).forEach(m -> {
            this.annotationValueValidator.validate((ModelConstraintAnnotation)m, restModelField);
            String constraintConstructorArg = m.getElementValues().entrySet().stream().filter(e -> !"off".equals(((ExecutableElement)e.getKey()).getSimpleName().toString())).map(e -> this.convertAnnotationValue(builder, restModelField, (ModelConstraintAnnotation)m, (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>)e)).collect(Collectors.joining(", "));
            String constructorArg = this.getConstructorArgs(builder, modelFieldType, constraintConstructorArg, m.isIterableConstraint());
            boolean validateIterable = m.isIterableConstraint() ? false : modelFieldType.isIterable();
            builder.add(restModelField, modelFieldType, (ModelValidatorCreatorDescriptor)m, constructorArg, validateIterable);
        });
        if (modelFieldType.isObject()) {
            builder.add(restModelField, modelFieldType.asObject().getJavaSimpleClassName(), false);
        } else if (modelFieldType.isIterable() && modelFieldType.asIterable().isObjectIterable()) {
            builder.add(restModelField, modelFieldType.asIterable().getElementModelClass().getJavaSimpleClassName(), true);
        }
    }

    private String convertAnnotationValue(ModelValidatorClassStructure.Builder builder, RestModelField restModelField, ModelConstraintAnnotation modelConstraintAnnotation, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        String result = this.annotationValueConverter.convert(restModelField.getFieldElement(), builder.getClassHeaderBuilder(), entry.getValue().getValue());
        if (MinNumber.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName()) || MaxNumber.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            return Numbers.removeUnderscoresIfPresent((String)result);
        }
        return result;
    }

    private String getConstructorArgs(ModelValidatorClassStructure.Builder builder, ModelClass modelFieldType, String constraintConstructorArg, boolean isListConstraint) {
        ModelClass elementModelClass;
        if (isListConstraint) {
            return constraintConstructorArg;
        }
        if (modelFieldType.isEnum()) {
            builder.getClassHeaderBuilder().addImports(new String[]{modelFieldType.getJavaFullClassName()});
            return modelFieldType.getJavaSimpleClassName() + ".class, " + constraintConstructorArg;
        }
        if (modelFieldType.isIterable() && (elementModelClass = modelFieldType.asIterable().getElementModelClass()).isEnum()) {
            builder.getClassHeaderBuilder().addImports(new String[]{elementModelClass.getJavaFullClassName()});
            return elementModelClass.getJavaSimpleClassName() + ".class, " + constraintConstructorArg;
        }
        return constraintConstructorArg;
    }
}

