/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.IterableModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorClassStructure;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorCreatorDescriptor;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.constraint.AllowEmptyString;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.Length;
import io.rxmicro.validation.constraint.MinLength;
import io.rxmicro.validation.constraint.Nullable;
import io.rxmicro.validation.constraint.NullableArrayItem;
import io.rxmicro.validation.validator.NotEmptyStringConstraintValidator;
import io.rxmicro.validation.validator.RequiredAndNotEmptyStringConstraintValidator;
import io.rxmicro.validation.validator.RequiredConstraintValidator;
import io.rxmicro.validation.validator.RequiredListConstraintValidator;
import io.rxmicro.validation.validator.RequiredMapConstraintValidator;
import io.rxmicro.validation.validator.RequiredSetConstraintValidator;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class RestModelRequiredValidatorBuilder {
    private final Map<String, Class<? extends ConstraintValidator<?>>> iterableRequiredValidators = Map.of(List.class.getSimpleName(), RequiredListConstraintValidator.class, Set.class.getSimpleName(), RequiredSetConstraintValidator.class, Map.class.getSimpleName(), RequiredMapConstraintValidator.class);

    public void addRequiredValidator(ModelValidatorClassStructure.Builder builder, RestModelField restModelField, ModelClass modelFieldType) {
        if (modelFieldType.isIterable()) {
            NullableArrayItem nullableArrayItem;
            boolean isArrayItemNotNull;
            Nullable nullable = restModelField.getAnnotation(Nullable.class);
            if (nullable == null || nullable.off()) {
                RequiredModelValidatorCreatorDescriptor descriptor = new RequiredModelValidatorCreatorDescriptor(Nullable.class, this.getIterableRequiredValidator(modelFieldType.asIterable()));
                builder.add(restModelField, modelFieldType, descriptor, null, false);
            }
            boolean bl = isArrayItemNotNull = (nullableArrayItem = restModelField.getAnnotation(NullableArrayItem.class)) == null || nullableArrayItem.off();
            if (modelFieldType.asIterable().isPrimitiveIterable() && String.class.getName().equals(modelFieldType.asIterable().getElementModelClass().getJavaFullClassName())) {
                this.addRequiredStringValidator(isArrayItemNotNull, NullableArrayItem.class, builder, restModelField, modelFieldType, true);
            } else if (isArrayItemNotNull) {
                RequiredModelValidatorCreatorDescriptor descriptor = new RequiredModelValidatorCreatorDescriptor(NullableArrayItem.class, RequiredConstraintValidator.class);
                builder.add(restModelField, modelFieldType, descriptor, null, true);
            }
        } else if (modelFieldType.isPrimitive() && String.class.getName().equals(modelFieldType.asPrimitive().getJavaFullClassName())) {
            Nullable nullable = restModelField.getAnnotation(Nullable.class);
            this.addRequiredStringValidator(nullable == null || nullable.off(), Nullable.class, builder, restModelField, modelFieldType, false);
        } else {
            Nullable nullable = restModelField.getAnnotation(Nullable.class);
            if (nullable == null || nullable.off()) {
                RequiredModelValidatorCreatorDescriptor descriptor = new RequiredModelValidatorCreatorDescriptor(Nullable.class, RequiredConstraintValidator.class);
                builder.add(restModelField, modelFieldType, descriptor, null, false);
            }
        }
    }

    private Class<? extends ConstraintValidator<?>> getIterableRequiredValidator(IterableModelClass iterableModelClass) {
        return Optional.ofNullable(this.iterableRequiredValidators.get(iterableModelClass.getContainerType())).orElseThrow(() -> {
            throw new InternalErrorException("Required iterable validator not defined for type: ?!", new Object[]{iterableModelClass.getContainerType()});
        });
    }

    private void addRequiredStringValidator(boolean isNullable, Class<? extends Annotation> constraintAnnotationClass, ModelValidatorClassStructure.Builder builder, RestModelField restModelField, ModelClass modelFieldType, boolean validateIterable) {
        RequiredModelValidatorCreatorDescriptor descriptor = null;
        if (isNullable) {
            descriptor = this.shouldNotEmptyValidatorBeAdded(restModelField) ? new RequiredModelValidatorCreatorDescriptor(constraintAnnotationClass, RequiredAndNotEmptyStringConstraintValidator.class) : new RequiredModelValidatorCreatorDescriptor(constraintAnnotationClass, RequiredConstraintValidator.class);
        } else if (this.shouldNotEmptyValidatorBeAdded(restModelField)) {
            descriptor = new RequiredModelValidatorCreatorDescriptor(constraintAnnotationClass, NotEmptyStringConstraintValidator.class);
        }
        if (descriptor != null) {
            builder.add(restModelField, modelFieldType, descriptor, null, validateIterable);
        }
    }

    private boolean shouldNotEmptyValidatorBeAdded(RestModelField restModelField) {
        AllowEmptyString allowEmptyString = restModelField.getAnnotation(AllowEmptyString.class);
        if (allowEmptyString != null && !allowEmptyString.off()) {
            return false;
        }
        MinLength minLength = restModelField.getAnnotation(MinLength.class);
        if (minLength != null && !minLength.off()) {
            return false;
        }
        Length length = restModelField.getAnnotation(Length.class);
        if (length != null && !length.off()) {
            return false;
        }
        Enumeration enumeration = restModelField.getAnnotation(Enumeration.class);
        return enumeration == null || enumeration.off();
    }

    private static final class RequiredModelValidatorCreatorDescriptor
    implements ModelValidatorCreatorDescriptor {
        private final Class<? extends Annotation> annotationClass;
        private final Class<? extends ConstraintValidator<?>> validatorClass;

        private RequiredModelValidatorCreatorDescriptor(Class<? extends Annotation> annotationClass, Class<? extends ConstraintValidator<?>> validatorClass) {
            this.annotationClass = annotationClass;
            this.validatorClass = validatorClass;
        }

        @Override
        public String getConstraintAnnotationFullName() {
            return this.annotationClass.getName();
        }

        @Override
        public String getValidatorFullClassName() {
            return this.validatorClass.getName();
        }

        @Override
        public boolean isParametrizedConstraintValidator() {
            return false;
        }
    }
}

