/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ModelClassHierarchyBuilder;
import io.rxmicro.annotation.processor.common.component.ModelFieldBuilder;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.rest.component.RestGenerationContextBuilder;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestClassSignature;
import io.rxmicro.annotation.processor.rest.model.RestGenerationContext;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestModuleGeneratorConfig;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.rest.model.ExchangeFormatModule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class RestGenerationContextBuilderImpl
extends BaseProcessorComponent
implements RestGenerationContextBuilder {
    @Inject
    private ModelFieldBuilder<RestModelField, RestObjectModelClass> modelFieldBuilder;
    @Inject
    private ModelClassHierarchyBuilder<RestModelField, RestObjectModelClass> modelClassHierarchyBuilder;

    @Override
    public RestGenerationContext build(EnvironmentContext environmentContext, Class<? extends RestModuleGeneratorConfig> restModuleGeneratorConfigClass, Set<? extends RestClassSignature> restClassSignatures) {
        ModuleElement currentModule = environmentContext.getCurrentModule();
        RestModuleGeneratorConfig restModuleGeneratorConfig = (RestModuleGeneratorConfig)environmentContext.get(restModuleGeneratorConfigClass);
        ExchangeFormatModule exchangeFormatModule = restModuleGeneratorConfig.getExchangeFormatModule();
        this.validateModuleDependencies(environmentContext, exchangeFormatModule);
        List<MappedRestObjectModelClass> fromHttpDataModelClasses = this.getFromHttpDataModelClasses(restClassSignatures, restModuleGeneratorConfig, currentModule);
        List<MappedRestObjectModelClass> toHttpDataModelClasses = this.getToHttpDataModelClasses(restClassSignatures, restModuleGeneratorConfig, currentModule);
        this.addModelClassHierarchy(fromHttpDataModelClasses, toHttpDataModelClasses);
        return new RestGenerationContext(fromHttpDataModelClasses, toHttpDataModelClasses);
    }

    private void validateModuleDependencies(EnvironmentContext environmentContext, ExchangeFormatModule exchangeFormatModule) {
        if (!environmentContext.isRxMicroModuleEnabled(exchangeFormatModule.getRxMicroModule())) {
            throw new InterruptProcessingException((Element)environmentContext.getCurrentModule(), "Missing module dependency. Add \"requires ?;\" to module-info.java", new Object[]{exchangeFormatModule.getRxMicroModule().getName()});
        }
    }

    private List<MappedRestObjectModelClass> getFromHttpDataModelClasses(Set<? extends RestClassSignature> restClassStructures, RestModuleGeneratorConfig restModuleGeneratorConfig, ModuleElement currentModule) {
        Map fromHttpDataMap = this.modelFieldBuilder.build(restModuleGeneratorConfig.getFromHttpDataModelFieldType(), currentModule, (Set)restClassStructures.stream().flatMap(m -> m.getFromHttpDataModelTypes().stream()).collect(ExCollectors.toTreeSet((Comparator)Elements.UNIQUE_TYPES_COMPARATOR)), new ModelFieldBuilderOptions().setRequireDefConstructor(true));
        return this.group(fromHttpDataMap, restClassStructures.stream().flatMap(cl -> cl.getMethodSignatures().stream().flatMap(m -> m.getFromHttpDataType().map(r -> Map.entry(r.toString(), m.getHttpMethodMappings())).stream())).collect(Collectors.toList()));
    }

    private List<MappedRestObjectModelClass> getToHttpDataModelClasses(Set<? extends RestClassSignature> restClassStructures, RestModuleGeneratorConfig restModuleGeneratorConfig, ModuleElement currentModule) {
        Map toHttpDataMap = this.modelFieldBuilder.build(restModuleGeneratorConfig.getToHttpDataModelFieldType(), currentModule, (Set)restClassStructures.stream().flatMap(m -> m.getToHttpDataModelTypes().stream()).collect(ExCollectors.toTreeSet((Comparator)Elements.UNIQUE_TYPES_COMPARATOR)), new ModelFieldBuilderOptions());
        return this.group(toHttpDataMap, restClassStructures.stream().flatMap(cl -> cl.getMethodSignatures().stream().flatMap(m -> m.getToHttpDataType().map(r -> Map.entry(r.toString(), m.getHttpMethodMappings())).stream())).collect(Collectors.toList()));
    }

    private List<MappedRestObjectModelClass> group(Map<TypeElement, RestObjectModelClass> dataMap, List<Map.Entry<String, List<HttpMethodMapping>>> restModels) {
        HashMap<RestObjectModelClass, List> map = new HashMap<RestObjectModelClass, List>();
        for (Map.Entry<TypeElement, RestObjectModelClass> entry : dataMap.entrySet()) {
            map.computeIfAbsent(entry.getValue(), v -> new ArrayList()).addAll(restModels.stream().filter(e -> ((String)e.getKey()).equals(((TypeElement)entry.getKey()).asType().toString())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList()));
        }
        return map.entrySet().stream().map(e -> new MappedRestObjectModelClass((RestObjectModelClass)((Object)((Object)e.getKey())), (List)e.getValue())).collect(Collectors.toList());
    }

    private void addModelClassHierarchy(List<MappedRestObjectModelClass> fromHttpDataModelClasses, List<MappedRestObjectModelClass> toHttpDataModelClasses) {
        Set<String> notAbstractModelClassNames = Stream.concat(fromHttpDataModelClasses.stream().map(m -> m.getModelClass().getJavaFullClassName()), toHttpDataModelClasses.stream().map(m -> m.getModelClass().getJavaFullClassName())).collect(Collectors.toSet());
        this.addModelClassHierarchy(fromHttpDataModelClasses, notAbstractModelClassNames);
        this.addModelClassHierarchy(toHttpDataModelClasses, notAbstractModelClassNames);
    }

    private void addModelClassHierarchy(List<MappedRestObjectModelClass> mappedRestObjectModelClasses, Set<String> notAbstractModelClassNames) {
        for (int i = 0; i < mappedRestObjectModelClasses.size(); ++i) {
            MappedRestObjectModelClass mappedRestObjectModelClass = mappedRestObjectModelClasses.get(i);
            Optional modelClassListOptional = this.modelClassHierarchyBuilder.build((ObjectModelClass)mappedRestObjectModelClass.getModelClass(), notAbstractModelClassNames);
            if (!modelClassListOptional.isPresent()) continue;
            List list = (List)modelClassListOptional.get();
            mappedRestObjectModelClasses.set(i, new MappedRestObjectModelClass((RestObjectModelClass)((Object)list.get(list.size() - 1)), mappedRestObjectModelClass.getHttpMethodMappings()));
        }
    }
}

