/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.rest.component.PathVariableValidator;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.rest.PathVariable;
import io.rxmicro.rest.model.UrlSegments;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class PathVariableValidatorImpl
implements PathVariableValidator {
    @Override
    public void validateThatPathVariablesNotMissingOrRedundant(Element owner, HttpMethodMapping httpMethodMapping, UrlSegments urlSegments, TypeElement typeElement) {
        Set<String> pathVariables = this.getEditablePathVariables(typeElement);
        for (String variable : new HashSet(urlSegments.getVariables())) {
            if (pathVariables.remove(variable)) continue;
            throw new InterruptProcessingException(owner, "Redundant path variable declaration(s): ${?} in the '@?(\"?\")', because '?' does not contain field annotated by '@?(\"?\")' annotation", new Object[]{variable, httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri(), typeElement.getQualifiedName(), PathVariable.class.getSimpleName(), variable});
        }
        if (!pathVariables.isEmpty()) {
            throw new InterruptProcessingException(owner, "Missing path variable declaration(s): ? in the '@?(\"?\")'.", new Object[]{pathVariables, httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri()});
        }
    }

    @Override
    public void validateThatPathVariablesNotFound(Element owner, HttpMethodMapping httpMethodMapping, TypeElement typeElement) {
        Set<String> pathVariables = this.getEditablePathVariables(typeElement);
        if (!pathVariables.isEmpty()) {
            throw new InterruptProcessingException(owner, "Missing path variable declaration(s): ? in the '@?(\"?\")'.", new Object[]{pathVariables, httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri()});
        }
    }

    private Set<String> getEditablePathVariables(TypeElement typeElement) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (VariableElement field : Elements.allModelFields((TypeElement)typeElement)) {
            PathVariable pathVariable = field.getAnnotation(PathVariable.class);
            if (pathVariable == null) continue;
            result.add(!pathVariable.value().isEmpty() ? pathVariable.value() : field.getSimpleName().toString());
        }
        return result;
    }
}

