/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.component.BaseUrlBuilder;
import io.rxmicro.annotation.processor.rest.component.ParentUrlBuilder;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.rest.BaseUrlPath;
import io.rxmicro.rest.Version;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class ParentUrlBuilderImpl
extends BaseUrlBuilder
implements ParentUrlBuilder {
    @Override
    public ParentUrl build(TypeElement ownerClass) {
        BaseUrlPath[] baseUrlPaths;
        ParentUrl.Builder builder = new ParentUrl.Builder();
        Version version = ownerClass.getAnnotation(Version.class);
        if (version != null) {
            this.validate(ownerClass, version.value(), "Version value is invalid: ");
            builder.setVersion(version);
        }
        for (BaseUrlPath baseUrlPath : baseUrlPaths = (BaseUrlPath[])ownerClass.getAnnotationsByType(BaseUrlPath.class)) {
            String urlPath = baseUrlPath.value();
            this.validate(ownerClass, urlPath, "Base url path is invalid: ");
            if (baseUrlPath.position() == BaseUrlPath.Position.AFTER_VERSION) {
                builder.addAfterVersionUrlPath(this.getNormalizeUrlPath(ownerClass, urlPath));
                continue;
            }
            this.validateBeforePosition(ownerClass, version);
            builder.addBeforeVersionUrlPath(this.getNormalizeUrlPath(ownerClass, urlPath));
        }
        return builder.build();
    }

    private String getNormalizeUrlPath(TypeElement ownerClass, String urlPath) {
        String normalizeUrlPath = UrlPaths.normalizeUrlPath((String)urlPath);
        if (!normalizeUrlPath.equals(urlPath) && this.getBooleanOption("RX_MICRO_STRICT_MODE", false)) {
            throw new InterruptProcessingException((Element)ownerClass, "Invalid base url path: Expected '?', but actual is '?'!", new Object[]{normalizeUrlPath, urlPath});
        }
        return normalizeUrlPath;
    }

    private void validateBeforePosition(TypeElement ownerClass, Version version) {
        if (version == null || version.strategy() == Version.Strategy.HEADER) {
            throw new InterruptProcessingException((Element)ownerClass, "'@?' annotation contains redundant parameter: 'position'. Remove redundant parameter!", new Object[]{BaseUrlPath.class.getSimpleName()});
        }
    }

    private void validate(TypeElement ownerClass, String path, String validPrefix) {
        this.validateNotNull(ownerClass, path, validPrefix);
        this.validateNotEmpty(ownerClass, path, validPrefix);
        this.validateNotRoot(ownerClass, path, validPrefix);
        this.validateThatPathIsTrimmedValue(ownerClass, path, validPrefix);
    }
}

